; River Raid By Carol Shaw
; Adaptation to Grzybsoniada - Jakub Husak.
; System equates
;
; OS EQUATES
; ----------
; 
; Syntax:
; Use '=' for addresses
; and '<' for read addresses (ex: KBCODE)
; and '>' for write addresses (ex: STIMER)
; and '#' for values
; 
; IO EQUATES
; 
ICHID       = $0000
ICDNO       = $0001
ICCOM       = $0002
ICSTA       = $0003
ICBAL       = $0004
ICBAH       = $0005
ICPTL       = $0006
ICPTH       = $0007
ICBLL       = $0008
ICBLH       = $0009
ICAX1       = $000A
ICAX2       = $000B
ICAX3       = $000C
ICAX4       = $000D
ICAX5       = $000E
ICAX6       = $000F
; 
; DISPLAY LIST EQUATES
; 
ADLI        = $0080
AVB         = $0040
ALMS        = $0040
AVSCR       = $0020
AHSCR       = $0010
AJMP        = $0001
AEMPTY1     = $0000
AEMPTY2     = $0010
AEMPTY3     = $0020
AEMPTY4     = $0030
AEMPTY5     = $0040
AEMPTY6     = $0050
AEMPTY7     = $0060
AEMPTY8     = $0070
; 
; OS VARIABLES FOR XL/XE
; 
; PAGE 0
; 
SPRCOLPTR      = $0002
RAMLO       = $0004
TRAMSZ      = $0006
CMCMD       = $0007
WARMST      = $0008
BOOT        = $0009
DOSVEC      = $000A
DOSINI      = $000C
APPMHI      = $000E
POKMSK      = $0010
BRKKEY      = $0011
RTCLOK      = $0012
BUFADR      = $0015
ICCOMT      = $0017
DSKFMS      = $0018
STICK_BUF   = $0019
DSKUTL      = $001A
ABUFPT      = $001C
ICHIDZ      = $0020
ICDNOZ      = $0021
ICCOMZ      = $0022
ICSTAZ      = $0023
ICBALZ      = $0024
ICBAHZ      = $0025
ICPTLZ      = $0026
ICPTHZ      = $0027
ICBLLZ      = $0028
ICBLHZ      = $0029
ICAX1Z      = $002A
ICAX2Z      = $002B
ICAX3Z      = $002C
ICAX4Z      = $002D
ICAX5Z      = $002E
ICAX6Z      = $002F
STATUS      = $0030
CHKSUM      = $0031
BUFRLO      = $0032
BUFRHI      = $0033
BFENLO      = $0034
BFENHI      = $0035
LTEMP       = $0036
TANK_IND      = $0038
RECVDN      = $0039
XMTDON      = $003A
CHKSNT      = $003B
NOCKSM      = $003C
BPTR        = $003D
FTYPE       = $003E
FEOF        = $003F
TANKMISSLVPOS        = $0040
SOUNDR      = $0041
CRITIC      = $0042
FMSZPG      = $0043
ZCHAIN      = $004A
DSTAT       = $004C
ATRACT      = $004D
DRKMSK      = $004E
COLRSH      = $004F
TANKMISSLHIND        = $0050
HOLD1       = $0051
LMARGN      = $0052
RMARGN      = $0053
ROWCRS      = $0054
COLCRS      = $0055
MISSILEVPOS = $0056
DINDEX      = $0057
CRAFT_LRSPEED      = $0058
CRAFT_SPEED      = $0059
OLDROW      = $005A
FUEL      = $005B
OLDCHR      = $005D
CRAFT_IND      = $005E
OLD_ADR_HI  = $005F
FKDEF       = $0060
PALNTS      = $0062
LOGCOL      = $0063
ADRESS      = $0064
MLTTMP      = $0066
SAVADR      = $0068
RAMTOP      = $006A
BUFCNT      = $006B
BUFSTR      = $006C
BITMSK      = $006E
SHFAMT      = $006F
ROWAC       = $0070
ROWAC1       = $0071
COLAC       = $0072
ENDPT       = $0074
INGAME      = $0076
DELTAC      = $0077
KEYDEF      = $0079
LOWFUELPITCH      = $007B
EXPL_CNT      = $007C
CRMISSL_CNT      = $007D
COUNTR      = $007E
LOMEM       = $0080
; 
; PAGE 2
; 
VDSLST      = $0200
VPRCED      = $0202
VINTER      = $0204
VBREAK      = $0206
VKEYBD      = $0208
VSERIN      = $020A
VSEROR      = $020C
VSEROC      = $020E
VTIMR1      = $0210
VTIMR2      = $0212
VTIMR4      = $0214
VIMIRQ      = $0216
CDTMV1      = $0218
CDTMV2      = $021A
CDTMV3      = $021C
CDTMV4      = $021E
CDTMV5      = $0220
VVBLKI      = $0222
VVBLKD      = $0224
CDTMA1      = $0226
CDTMA2      = $0228
CDTMF3      = $022A
SRTIMR      = $022B
CDTMF4      = $022C
INTEMP      = $022D
CDTMF5      = $022E
SDMCTL      = $022F
SDLSTL      = $0230
SDLSTH      = $0231
SSKCTL      = $0232
SPARE       = $0233
LPENH       = $0234
LPENV       = $0235
BRKKY       = $0236
VPIRQ       = $0238
CDEVIC      = $023A
CCOMND      = $023B
CAUX1       = $023C
CAUX2       = $023D
TMPSIO      = $023E
ERRFLG      = $023F
DFLAGS      = $0240
DBSECT      = $0241
BOOTAD      = $0242
COLDST      = $0244
RECLEN      = $0245
DSKTIM      = $0246
PDVMSK      = $0247
SHPDVS      = $0248
PDMSK       = $0249
RELADR      = $024A
PPTMPA      = $024C
PPTMPX      = $024D
CHSALT      = $026B
VSFLAG      = $026C
KEYDIS      = $026D
FINE        = $026E
GPRIOR      = $026F
PADDL0      = $0270
PADDL1      = $0271
PADDL2      = $0272
PADDL3      = $0273
PADDL4      = $0274
PADDL5      = $0275
PADDL6      = $0276
PADDL7      = $0277
STICK0      = $0278
STICK1      = $0279
STICK2      = $027A
STICK3      = $027B
PTRIG0      = $027C
PTRIG1      = $027D
PTRIG2      = $027E
PTRIG3      = $027F
PTRIG4      = $0280
PTRIG5      = $0281
PTRIG6      = $0282
PTRIG7      = $0283
STRIG0      = $0284
STRIG1      = $0285
STRIG2      = $0286
STRIG3      = $0287
HIBYTE      = $0288
WMODE       = $0289
BLIM        = $028A
IMASK       = $028B
JVECK       = $028C
NEWADR      = $028E
TXTROW      = $0290
TXTCOL      = $0291
TINDEX      = $0293
TXTMSC      = $0294
TXTOLD      = $0296
CRETRY      = $029C
HOLD3       = $029D
SUBTMP      = $029E
HOLD2       = $029F
DMASK       = $02A0
TMPLBT      = $02A1
ESCFLG      = $02A2
TABMAP      = $02A3
LOGMAP      = $02B2
INVFLG      = $02B6
FILFLG      = $02B7
TMPROW      = $02B8
TMPCOL      = $02B9
SCRFLG      = $02BB
HOLD4       = $02BC
DRETRY      = $02BD
SHFLOC      = $02BE
BOTSCR      = $02BF
PCOLR0      = $02C0
PCOLR1      = $02C1
PCOLR2      = $02C2
PCOLR3      = $02C3
;COLOR0      = $02C4
;COLOR1      = $02C5
;COLOR2      = $02C6
;COLOR3      = $02C7
;COLOR4      = $02C8
RUNADR      = $02C9
HIUSED      = $02CB
ZHIUSE      = $02CD
GBYTEA      = $02CF
LOADAD      = $02D1
ZLOADA      = $02D3
DSCTLN      = $02D5
ACMISR      = $02D7
KRPDER      = $02D9
KEYREP      = $02DA
NOCLIK      = $02DB
HELPFG      = $02DC
DMASAV      = $02DD
PBPNT       = $02DE
PBUFSZ      = $02DF
RUNAD       = $02E0
INITAD      = $02E2
RAMSIZ      = $02E4
MEMTOP      = $02E5
MEMLO       = $02E7
HNDLOD      = $02E9
DVSTAT      = $02EA
CBAUDL      = $02EE
CBAUDH      = $02EF
CRSINH      = $02F0
KEYDEL      = $02F1
CH1         = $02F2
CHACT       = $02F3
CHBAS       = $02F4
NEWROW      = $02F5
NEWCOL      = $02F6
ROWINC      = $02F8
COLINC      = $02F9
CHAR        = $02FA
ATACHR      = $02FB
CH          = $02FC
FILDAT      = $02FD
DSPFLG      = $02FE
SSFLAG      = $02FF
; 
; PAGE 3
; 
DDEVIC      = $0300
DUNIT       = $0301
DCOMND      = $0302
DSTATS      = $0303
DBUFLO      = $0304
DBUFHI      = $0305
DTIMLO      = $0306
DUNUSE      = $0307
DBYTLO      = $0308
DBYTHI      = $0309
DAUX1       = $030A
DAUX2       = $030B
TIMER1      = $030C
ADDCOR      = $030E
CASFLG      = $030F
TIMER2      = $0310
TEMP1       = $0312
TEMP2       = $0314
TEMP3       = $0315
SAVIO       = $0316
TIMFLG      = $0317
STACKP      = $0318
TSTAT       = $0319
HATABS      = $031A
PUPBT1      = $033D
PUPBT2      = $033E
PUPBT3      = $033F
IOCB0       = $0340
IOCB1       = $0350
IOCB2       = $0360
IOCB3       = $0370
IOCB4       = $0380
IOCB5       = $0390
IOCB6       = $03A0
IOCB7       = $03B0
PRNBUF      = $03C0
SUPERF      = $03E8
CKEY        = $03E9
CASSBT      = $03EA
CARTCK      = $03EB
DERRF       = $03EC
ACMVAR      = $03ED
BASICF      = $03F8
MINTLK      = $03F9
GINTLK      = $03FA
CHLINK      = $03FB
CASBUF      = $03FD
; 
; HARDWARE REGISTERS
; 
; GTIA
; 
M0PF        = $D000
HPOSP0      = $D000
M1PF        = $D001
HPOSP1      = $D001
M2PF        = $D002
HPOSP2      = $D002
M3PF        = $D003
HPOSP3      = $D003
P0PF        = $D004
HPOSM0      = $D004
P1PF        = $D005
HPOSM1      = $D005
P2PF        = $D006
HPOSM2      = $D006
P3PF        = $D007
HPOSM3      = $D007
M0PL        = $D008
SIZEP0      = $D008
M1PL        = $D009
SIZEP1      = $D009
M2PL        = $D00A
SIZEP2      = $D00A
M3PL        = $D00B
SIZEP3      = $D00B
P0PL        = $D00C
SIZEM       = $D00C
P1PL        = $D00D
GRAFP0      = $D00D
P2PL        = $D00E
GRAFP1      = $D00E
P3PL        = $D00F
GRAFP2      = $D00F
TRIG0       = $D010
GRAFP3      = $D010
TRIG1       = $D011
GRAFM       = $D011
TRIG2       = $D012
COLPM0      = $D012
TRIG3       = $D013
COLPM1      = $D013
PAL         = $D014
COLPM2      = $D014
COLPM3      = $D015
COLPF0      = $D016
COLPF1      = $D017
COLPF2      = $D018
COLPF3      = $D019
COLBK       = $D01A
COLBAK       = $D01A
PRIOR       = $D01B
GTICTL       = $D01B
VDELAY      = $D01C
GRACTL      = $D01D
PMCNTL      = $D01D
HITCLR      = $D01E
CONSOL      = $D01F
; 
; POKEY
; 
POT0        = $D200
AUDF1       = $D200
POT1        = $D201
AUDC1       = $D201
POT2        = $D202
AUDF2       = $D202
POT3        = $D203
AUDC2       = $D203
POT4        = $D204
AUDF3       = $D204
POT5        = $D205
AUDC3       = $D205
POT6        = $D206
AUDF4       = $D206
POT7        = $D207
AUDC4       = $D207
ALLPOT      = $D208
AUDCTL      = $D208
KBCODE      = $D209
STIMER      = $D209
RANDOM      = $D20A
SKREST      = $D20A
POTGO       = $D20B
SERIN       = $D20D
SEROUT      = $D20D
IRQST       = $D20E
IRQEN       = $D20E
SKSTAT      = $D20F
SKCTL       = $D20F
; 
; PIA
; 
PORTA       = $D300
PORTB       = $D301
PACTL       = $D302
PBCTL       = $D303
; 
; ANTIC
; 
DMACTL      = $D400
CHACTL      = $D401
DLISTL      = $D402
DLPTR      = $D402
DLISTH      = $D403
HSCROL      = $D404
VSCROL      = $D405
PMBASE      = $D407
CHBASE      = $D409
WSYNC       = $D40A
VCOUNT      = $D40B
PENH        = $D40C
PENV        = $D40D
NMIEN       = $D40E
NMIST       = $D40F
NMIRES      = $D40F
COLOR0	=	COLPF0
COLOR1	=	COLPF1
COLOR2	=	COLPF2
COLOR3	=	COLPF3
; 
; FLOATING POINT ROUTINES
; 
AFP         = $D800
FASC        = $D8E6
IFP         = $D9AA
FPI         = $D9D2
ZFR0        = $DA44
ZF1         = $DA46
FSUB        = $DA60
FADD        = $DA66
FMUL        = $DADB
FDIV        = $DB28
PLYEVL      = $DD40
FLD0R       = $DD89
FLD0P       = $DD8D
FLD1R       = $DD98
FLD1P       = $DD9C
FSTOR       = $DDA7
FSTOP       = $DDAB
FMOVE       = $DDB6
EXP         = $DDC0
EXP10       = $DDCC
LOG         = $DECD
LOG10       = $DED1
; 
; ROM VECTORS
; 
DSKINV      = $E453
CIOV        = $E456
SIOV        = $E459
SETVBV      = $E45C
SYSVBV      = $E45F
XITVBV      = $E462
SIOINV      = $E465
SENDEV      = $E468
INTINV      = $E46B
CIOINV      = $E46E
SELFSV      = $E471
WARMSV      = $E474
COLDSV      = $E477
RBLOKV      = $E47A
CSOPIV      = $E47D
PUPDIV      = $E480
SELFTSV     = $E483
PENTV       = $E486
PHUNLV      = $E489
PHINIV      = $E48C
GPDVV       = $E48F
;
; Code equates
;
L0090       = $0090
L00A0       = $00A0
L00A1       = $00A1
L00A2       = $00A2
L00A3       = $00A3
L00A4       = $00A4
L00A5       = $00A5
L00A6       = $00A6
L00A7       = $00A7
L00A8       = $00A8
L00A9       = $00A9
L00AA       = $00AA
L00AB       = $00AB
L00AC       = $00AC
L00AD       = $00AD
L00AE       = $00AE
L00AF       = $00AF
L00B0       = $00B0
L00B1       = $00B1
L00B2       = $00B2
L00B3       = $00B3
L00B4       = $00B4
L00B5       = $00B5
L00B6       = $00B6
L00B7       = $00B7
L00B8       = $00B8
L00B9       = $00B9
L00BA       = $00BA
L00BB       = $00BB
CURRMOUNTWIDTH       = $00BC
L00BD       = $00BD
L00BE       = $00BE
L00BF       = $00BF
L00C0       = $00C0
L00C1       = $00C1
L00C2       = $00C2
L00C3       = $00C3
L00C4       = $00C4
L00C5       = $00C5
L00C6       = $00C6
L00C7       = $00C7
L00C8       = $00C8
L00C9       = $00C9
L00CA       = $00CA
L00CB       = $00CB
L0500       = $0500
L0501       = $0501
L050B       = $050B
L050C       = $050C
L0515       = $0515
L0516       = $0516
L0517       = $0517
L0521       = $0521
L0522       = $0522
L052C       = $052C
L052D       = $052D
L0600       = $0600
L06C0       = $06C0
L0700       = $0700
L07D0       = $07D0
L0800       = $0800
L0818       = $0818
L08D0       = $08D0
L0900       = $0900
L0AFE       = $0AFE
L0AFF       = $0AFF
L0B00       = $0B00
L0B01       = $0B01
L0B02       = $0B02
L0B03       = $0B03
L0B04       = $0B04
L0B05       = $0B05
L0B06       = $0B06
L0B07       = $0B07
L0B08       = $0B08
L0BCC       = $0BCC
L0EAA       = $0EAA
L0EBC       = $0EBC
L0EBD       = $0EBD
L0EDB       = $0EDB
L0FDB       = $0FDB
L1000       = $1000
L100B       = $100B
L1012       = $1012
L102A       = $102A
L102B       = $102B
L1033       = $1033
L200E       = $200E
L3F00       = $3F00
L3F04       = $3F04
L3F05       = $3F05
L3F06       = $3F06
L3F07       = $3F07
L3F08       = $3F08
L3F57       = $3F57
L3F58       = $3F58
L3F59       = $3F59
L3FA6       = $3FA6
L3FA7       = $3FA7
L3FA8       = $3FA8
L3FA9       = $3FA9
L3FB3       = $3FB3
L6000       = $6000
LB4D2       = $B4D2
LB7F5       = $B7F5
LBAB8       = $BAB8
LBACE       = $BACE
LBBF1       = $BBF1
LE000       = $E000
LE100       = $E100
LE300       = $E300
;
; Start of code
;

	icl 'river8.asm'

		org $8000
	icl 'rrintro.asm'

	

KAYAK:
KS0:
        .by %00000000
        .by %00010000
        .by %00010000
        .by %00111000
        .by %00111000
        .by %00111000
        .by %00101000
        .by %10011000
        .by %11110010
        .by %10011110
        .by %00101010
        .by %00111000
        .by %00010000
        .by %00010000
        .by %00000000
        .by %00000000
KS1:
        .by %00000000
        .by %00010000
        .by %00010000
        .by %00111000
        .by %00111000
        .by %00111000
        .by %00101000
        .by %10011000
        .by %11110010
        .by %00011110
        .by %00101010
        .by %00111000
        .by %00010010
        .by %00010000
        .by %00101000
        .by %00000000
KS2:
        .by %00010000
        .by %00010000
        .by %00111000
        .by %00111000
        .by %00111010
        .by %00101010
        .by %00010110
        .by %00111000
        .by %01011000
        .by %11101000
        .by %10111000
        .by %00010000
        .by %00010000
        .by %00000000
        .by %00010010
        .by %01000100
KS3:
        .by %00000000
        .by %00010000
        .by %00010000
        .by %00111000
        .by %00111000
        .by %00111000
        .by %00101000
        .by %00010010
        .by %10011110
        .by %11110000
        .by %10101000
        .by %00111000
        .by %10010000
        .by %00010000
        .by %00101000
        .by %00000000
KS4:
        .by %00010000
        .by %00010000
        .by %00111000
        .by %00111000
        .by %10111000
        .by %10101000
        .by %11010000
        .by %00111000
        .by %00110100
        .by %00101110
        .by %00111010
        .by %00010000
        .by %00010000
        .by %00000000
        .by %10000000
        .by %01000100
KL1:
        .by %00000000
        .by %10000000
        .by %11000110
        .by %11100110
        .by %01111000
        .by %01110000
        .by %01101000
        .by %10111000
        .by %10111000
        .by %00011100
        .by %00011100
        .by %00001100
        .by %00000101
        .by %00000000
        .by %00000001
        .by %00001000
KL2:
        .by %00000000
        .by %10000000
        .by %11000000
        .by %11100000
        .by %01110010
        .by %01110110
        .by %01101000
        .by %10111000
        .by %00111000
        .by %00011100
        .by %00011100
        .by %00001100
        .by %00000100
        .by %00000001
        .by %00000100
        .by %00000000
KL3:
        .by %00000000
        .by %10000000
        .by %11000000
        .by %11100000
        .by %01110000
        .by %01110000
        .by %11101010
        .by %00111110
        .by %00111000
        .by %00011100
        .by %00011100
        .by %00001100
        .by %00000100
        .by %00000000
        .by %00000001
        .by %00001000
KL4:
        .by %00000000
        .by %10000000
        .by %11000000
        .by %11100000
        .by %01110000
        .by %01110011
        .by %01101111
        .by %10111000
        .by %00111000
        .by %00011101
        .by %00011100
        .by %00001100
        .by %00000100
        .by %00000001
        .by %00000100
        .by %00000001
KR1:
        .by %00000000
        .by %00000001
        .by %01100011
        .by %01100111
        .by %00011110
        .by %00001110
        .by %00010110
        .by %00011101
        .by %00011101
        .by %00111000
        .by %00111000
        .by %00110000
        .by %10100000
        .by %00000000
        .by %10000000
        .by %00010000
KR2:
        .by %00000000
        .by %00000001
        .by %00000011
        .by %00000111
        .by %01001110
        .by %01101110
        .by %00010110
        .by %00011101
        .by %00011100
        .by %00111000
        .by %00111000
        .by %00110000
        .by %00100000
        .by %10000000
        .by %00100000
        .by %10000000
KR3:
        .by %00000000
        .by %00000001
        .by %00000011
        .by %00000111
        .by %00001110
        .by %00001110
        .by %01010111
        .by %01111100
        .by %00011100
        .by %00111000
        .by %00111000
        .by %00110000
        .by %00100000
        .by %00000000
        .by %10000000
        .by %00010000
KR4:
        .by %00000000
        .by %00000001
        .by %00000011
        .by %00000111
        .by %00001110
        .by %11001110
        .by %11110110
        .by %00011101
        .by %00011100
        .by %10111000
        .by %00111000
        .by %00110000
        .by %00100000
        .by %10000000
        .by %00100000
        .by %10000000

ANIM:	.word KR1,KR2,KR3,KR4
	.word KL1,KL2,KL3,KL4
	.word KS1,KS2,KS3,KS4
ANIMSPEED:
	.byte 31,31,31,63
INCR:
	.by 0,0,0,0,1,1,2,2,3,4,4,5,5,6,6,6
WATERF:
	.by 0,15,30,45,40,30,29,25,20,18,14, 11,10,9,8,7,9,5
WATERC
	.by $84,$83,$83,$82
	.by $81,$80,$80,$80
	.by $80,$80,$81,$81
	.by $82,$82,$81,$81

ANIMATEK:  
	lda INGAME             ; 24 29
	bne A_NEXT0
      	lda STICK_BUF           ; A5 19
	and #$03               ; 29 03
	tax                    ; AA
	lda LB4AC,X            ; BD AC B4
	and #$f
	sta $81

	lda CRAFT_SPEED
	lsr
	lsr
	lsr
	lsr
	tay
	lda STICK_BUF
	lsr
	lsr
	tax
	lda INCR,y
	clc
	adc COLCRS
	and ANIMSPEED,x
	sta COLCRS
	lsr
	lsr
	cpx #3
	bne A_NEXT1
	lsr
A_NEXT1:
	and #$FE
	tay
	lda ANIM,y
	sta KAYAKRIGHT
	lda ANIM+1,y
	sta KAYAKRIGHT+1
	lda ANIM+8,y
	sta KAYAKLEFT
	lda ANIM+9,y
	sta KAYAKLEFT+1
A_NEXT0:
	lda INGAME
	bne A_NEXT2

	lda ANIM+16,y
	sta KAYAKSTRAIGHT
	lda ANIM+17,y
	sta KAYAKSTRAIGHT+1
	bne A_NEXT3
A_NEXT2:
	lda #<KS0
	sta KAYAKSTRAIGHT
	lda #>KS0
	sta KAYAKSTRAIGHT+1
A_NEXT3:
	lda INGAME
	bne EXIT
;            lda LOWFUELPITCH             ; A5 5B
;	    beq A_NEXT4
 ;           cmp #$1C              ; B0 29
;	    bcs EXIT
	    
A_NEXT4:
	lda COLCRS
	and #$1f
	lsr
	tay

	lda $82
	beq EXIT
	
	lda $81
	clc
	adc WATERC,y
	sec
	sbc #3
	sta AUDC1
	lda INCR,Y
	eor #8
	clc
	adc RANDOM
	and #15
	adc WATERF,y
	sta AUDF1

EXIT:	
	lda #0
	sta $82
	jmp XITVBV
	rts
MAKENOISEF:

	 ;txa
	 ;and #$0f
	 ;beq do_noise
	 ;txa
	 ;and #$f0
	 ;cmp #$a0
	 ;seq:rts

do_noise:
	    sty AUDF1              ; 8C 00 D2
MAKENOISEC
	    stx AUDC1              ; 8E 01 D2

	    rts

            org $A000
;
LA000:      lda #$00               ; A9 00
            sta NMIEN              ; 8D 0E D4
            sta IRQEN              ; 8D 0E D2
            sta GRACTL             ; 8D 1D D0
            sta DMACTL             ; 8D 00 D4
            tay                    ; A8
            sta PBCTL              ; 8D 03 D3
LA012:      sta HPOSP0,Y           ; 99 00 D0
            sta DMACTL,Y           ; 99 00 D4
            sta AUDF1,Y            ; 99 00 D2
            sta PORTA,Y            ; 99 00 D3
            iny                    ; C8
            bne LA012              ; D0 F1
            ldx #$38               ; A2 38
            stx PACTL              ; 8E 02 D3
            sta PORTA              ; 8D 00 D3
            ldx #$3C               ; A2 3C
            stx PACTL              ; 8E 02 D3
            ldx #$03               ; A2 03
            stx SKCTL              ; 8E 0F D2
            ldy #$0F               ; A0 0F
LA035:      sty L00A0              ; 84 A0
            jsr LB298              ; 20 98 B2
            cmp L0090,Y            ; D9 90 00
            beq LA043              ; F0 04
            ldy #$00               ; A0 00
            beq LA048              ; F0 05
LA043:      dey                    ; 88
            bpl LA035              ; 10 EF
            ldy #$A0               ; A0 A0
LA048:      lda #$00               ; A9 00
            sta $00                ; 85 00
            sta $01             ; 85 01
LA04E:      sta ($00),Y            ; 91 00
            iny                    ; C8
            bne LA04E              ; D0 FB
            inc $01             ; E6 01
            ldx $01             ; A6 01
            cpx #$40               ; E0 40
            bcc LA04E              ; 90 F3
            ldx #$03               ; A2 03
LA05D:      lda DISPLLISTH,X            ; BD 76 B7
            sta L3F00,X            ; 9D 00 3F
            dex                    ; CA
            bpl LA05D              ; 10 F7
            ldy #$0E               ; A0 0E
            ldx #$2E               ; A2 2E
            lda PAL                ; AD 14 D0
            and #$0E               ; 29 0E
            sta L00BF              ; 85 BF
            bne LA077              ; D0 04
            ldy #$1D               ; A0 1D
            ldx #$2F               ; A2 2F
LA077:      stx L00CB              ; 86 CB
            ldx #$0E               ; A2 0E
LA07B:      lda DISPLLISTP,Y            ; B9 7A B7
            sta L3FA9,X            ; 9D A9 3F
            dey                    ; 88
            dex                    ; CA
            bpl LA07B              ; 10 F6
            lda #$0E               ; A9 0E
            ldx #$A3               ; A2 A3
LA089:      sta L3F05,X            ; 9D 05 3F
            dex                    ; CA
            bne LA089              ; D0 FA
            stx L00A8              ; 86 A8
            sta L00A7              ; 85 A7
            lda #$4E               ; A9 4E
            sta L3F06              ; 8D 06 3F
            sta L3F57              ; 8D 57 3F
            stx L3F04              ; 8E 04 3F
            stx L3F58              ; 8E 58 3F
            ldx #$30               ; A2 30
            stx L3F07              ; 8E 07 3F
            ldx #$20               ; A2 20
            stx L3F05              ; 8E 05 3F
            stx L3F08              ; 8E 08 3F
            ldx #$30               ; A2 30
            stx L3F59              ; 8E 59 3F
            ldy #$02               ; A0 02
            sty L00A5              ; 84 A5
            ldy #$53               ; A0 53
            sty L00A6              ; 84 A6
            lda #$00               ; A9 00
            sta DLISTL             ; 8D 02 D4
            lda #$3F               ; A9 3F
            sta DLISTH             ; 8D 03 D4
            lda #<DLINT               ; A9 00
            sta VDSLST             ; 8D 00 02
            lda #>DLINT               ; A9 B5
            sta VDSLST+1           ; 8D 01 02
            ldx #>VBLK               ; A2 B2
            stx VVBLKI+1           ; 8E 23 02
            ldy #<VBLK               ; A0 A5
            sty VVBLKI             ; 8C 22 02
            lda #<IRQ               ; A9 85
            sta VIMIRQ             ; 8D 16 02
            lda #>IRQ              ; A9 B4
            sta VIMIRQ+1           ; 8D 17 02
            lda #$08               ; A9 08
            sta PMBASE             ; 8D 07 D4
            lda #$B9               ; A9 B9
            sta $01             ; 85 01
            lda #$B7               ; A9 B7
            sta SPRCOLPTR+1           ; 85 03
            ldx #$3B               ; A2 3B
LA0F2:      lda LBB70,X            ; BD 70 BB
            sta L1000,X            ; 9D 00 10
            dex                    ; CA
            bpl LA0F2              ; 10 F7
	    ; FONTS
            ldx #$08               ; A2 08
LA0FD:      lda LE000,X            ; BD 00 E0
            sta L0800,X            ; 9D 00 08
            lda LE100,X            ; BD 00 E1
            sta L0900,X            ; 9D 00 09
            sta L0600,X            ; 9D 00 06
            lda LE300,X            ; BD 00 E3
            sta L0700,X            ; 9D 00 07
            inx                    ; E8
            bne LA0FD              ; D0 E8
            inx                    ; E8
            stx SIZEM              ; 8E 0C D0
            ldx #$3F               ; A2 3F
LA11B:      lda ACTIVISIONTFONT,X            ; BD EE BE
            sta L06C0,X            ; 9D C0 06
            dex                    ; CA
            bpl LA11B              ; 10 F7
            ldx #$6F               ; A2 6F
LA126:      lda STATUSFONT,X            ; BD 2E BF
            sta L0818,X            ; 9D 18 08
            dex                    ; CA
            bpl LA126              ; 10 F7
            ldx #$17               ; A2 17
LA131:      lda LBF9E,X            ; BD 9E BF
            sta L08D0,X            ; 9D D0 08
            dex                    ; CA
            bpl LA131              ; 10 F7
            ldx #$2F               ; A2 2F
LA13C:      lda LBFB6,X            ; BD B6 BF
            sta L07D0,X            ; 9D D0 07
            dex                    ; CA
            bpl LA13C              ; 10 F7
            lda #$9B               ; A9 9B
            sta L00A1              ; 85 A1
            lda #$A1               ; A9 A1
            sta L00A2              ; 85 A2
            ldy #$00               ; A0 00
            lda #$FF               ; A9 FF
            ldx L6000              ; AE 00 60
            cpx #$47               ; E0 47
            beq LA15A              ; F0 02
            nop                    ; EA
            nop                    ; EA
LA15A:      cli                    ; 58
            ldx #$09               ; A2 09
LA15D:      lda #$00               ; A9 00
LA15F:      sta $00,X              ; 95 00
            inx                    ; E8
            bpl LA15F              ; 10 FB
            ldx #$29               ; A2 29
            jsr LB0F1              ; 20 F1 B0
            jsr LAF80              ; 20 80 AF
            ldy ICBLLZ             ; A4 28
            bne LA17E              ; D0 0E
            inc ICBLLZ             ; E6 28
            lda #$01               ; A9 01
            sta ICAX1Z             ; 85 2A
            lda #$FF               ; A9 FF
            sta INGAME             ; 85 76
            ldx #$40               ; A2 40
            bne LA18D              ; D0 0F
LA17E:      bit ICBLHZ             ; 24 29
            bmi LA18B              ; 30 09
            jsr LAF5B              ; 20 5B AF
            jsr LB05C              ; 20 5C B0
            jsr LB07C              ; 20 7C B0
LA18B:      ldx #$C0               ; A2 C0
LA18D:      lda VCOUNT             ; AD 0B D4
            cmp #$78               ; C9 78
            bne LA18D              ; D0 F9
            stx NMIEN              ; 8E 0E D4
LA197:      lda VCOUNT             ; AD 0B D4
            cmp #$50               ; C9 50
            bcc LA197              ; 90 F9
            ldx PORTA              ; AE 00 D3
            inx                    ; E8
            bne LA1BF              ; D0 1B
            lda TRIG0              ; AD 10 D0
            beq LA1BF              ; F0 16
            lda TRIG1              ; AD 11 D0
            beq LA1BF              ; F0 11
            lda #$08               ; A9 08
            sta CONSOL             ; 8D 1F D0
            lda CONSOL             ; AD 1F D0
            lsr                    ; 4A
            bcc LA1BF              ; 90 06
            lsr                    ; 4A
            bcc LA1BF              ; 90 03
            lsr                    ; 4A
            bcs LA1C5              ; B0 06
LA1BF:      ldy #$00               ; A0 00
            sty DELTAC+1           ; 84 78
            sty ICBALZ             ; 84 24
LA1C5:      lda SKSTAT             ; AD 0F D2
            and #$04               ; 29 04
            bne LA1CE              ; D0 02
            sta DELTAC+1           ; 85 78
LA1CE:      ldx ICBALZ             ; A6 24
            bne LA1DC              ; D0 0A
            tax                    ; AA
            bne LA1F5              ; D0 20
            lda #$03               ; A9 03
            sta ICBALZ             ; 85 24
LA1D9:      jmp LAE99              ; 4C 99 AE
LA1DC:      cpx #$02               ; E0 02
            bcc LA1F0              ; 90 10
            beq LA1E9              ; F0 07
            tax                    ; AA
            beq LA1D9              ; F0 F4
            dec ICBALZ             ; C6 24
            bne LA1D9              ; D0 F0
LA1E9:      tax                    ; AA
            bne LA1D9              ; D0 ED
            dec ICBALZ             ; C6 24
            bne LA1F5              ; D0 05
LA1F0:      tax                    ; AA
            beq LA1F5              ; F0 02
            dec ICBALZ             ; C6 24
LA1F5:      lda DELTAC+1           ; A5 78
            bmi LA1D9              ; 30 E0
            lda DSKFMS             ; A5 18
            eor BUFRHI             ; 45 33
            sta L00B1              ; 85 B1
            lda DSKFMS             ; A5 18
            and #$0F               ; 29 0F
            bne LA21B              ; D0 16
            lda RANDOM             ; AD 0A D2
            and #$0F               ; 29 0F
            cmp #$0B               ; C9 0B
            bcc LA210              ; 90 02
            sbc #$05               ; E9 05
LA210:      tax                    ; AA
            cpx DRKMSK             ; E4 4E
            beq LA21B              ; F0 06
            lda CRITIC,X           ; B5 42
            ora #$40               ; 09 40
            sta CRITIC,X           ; 95 42
LA21B:      lda #$0F               ; A9 0F
            ldx TANK_IND             ; A6 38
            cpx #$08               ; E0 08
            bcs LA229              ; B0 06
            cpx #$04               ; E0 04
            bcc LA229              ; 90 02
            lda #$03               ; A9 03
LA229:      and DSKFMS             ; 25 18
            bne LA26C              ; D0 3F
            lda TANKMISSLHIND               ; A5 50
            bpl LA261              ; 10 30
            bit ICBLHZ             ; 24 29
            bmi LA239              ; 30 04
            lda INGAME             ; A5 76
            bne LA261              ; D0 28
LA239:      bit SOUNDR             ; 24 41
            bpl LA24F              ; 10 12
            lda XMTDON             ; A5 3A
            cmp #$1A               ; C9 1A
            bcc LA261              ; 90 1E
            bit TANKMISSLHIND               ; 24 50
            bpl LA261              ; 10 1A
            bit ICHIDZ             ; 24 20
            bmi LA253              ; 30 08
            inc TANKMISSLHIND               ; E6 50
            bpl LA261              ; 10 12
LA24F:      lda ICAX5Z             ; A5 2E
            bne LA261              ; D0 0E
LA253:      lda TANK_IND             ; A5 38
            and #$7F               ; 29 7F
            cmp #$06               ; C9 06
            bcs LA25F              ; B0 04
            inc RECVDN             ; E6 39
            bcc LA261              ; 90 02
LA25F:      dec RECVDN             ; C6 39
LA261:      lda #$03               ; A9 03
            ldx TANK_IND             ; A6 38
            bmi LA26A              ; 30 03
            lda LBAAF,X            ; BD AF BA
LA26A:      sta TANK_IND             ; 85 38
LA26C:      ldx ATRACT             ; A6 4D
            jmp LA2EE              ; 4C EE A2
LA271:      ldy L0500,X            ; BC 00 05
            cpy #$0E               ; C0 0E
            bcs LA2ED              ; B0 75
            cpy #$0C               ; C0 0C
            bcs LA28F              ; B0 13
            lda #$01               ; A9 01
            cpy #$07               ; C0 07
            bcs LA284              ; B0 02
            lda #$07               ; A9 07
LA284:      and DSKFMS             ; 25 18
            bne LA28F              ; D0 07
            lda LBB24,Y            ; B9 24 BB
            sta L0500,X            ; 9D 00 05
            tay                    ; A8
LA28F:      bit ICBLHZ             ; 24 29
            bmi LA297              ; 30 04
            lda INGAME             ; A5 76
            bne LA2ED              ; D0 56
LA297:      lda FKDEF              ; A5 60
            lsr                    ; 4A
            beq LA2ED              ; F0 51
            cpy #$07               ; C0 07
            beq LA2CA              ; F0 2A
            bcc LA2ED              ; 90 4B
            cpy #$0C               ; C0 0C
            bne LA2AC              ; D0 06
            lda DSKFMS             ; A5 18
            and #$02               ; 29 02
            bne LA2ED              ; D0 41
LA2AC:      txa                    ; 8A
            eor L00B1              ; 45 B1
            ror                    ; 6A
            bcs LA2ED              ; B0 3B
            lda CRITIC,X           ; B5 42
            rol                    ; 2A
            bpl LA2ED              ; 10 36
            ror                    ; 6A
            ror                    ; 6A
            bcc LA2C5              ; 90 0A
            rol                    ; 2A
            bit LB964              ; 2C 64 B9
            bne LA2CA              ; D0 09
            eor #$18               ; 49 18
            bne LA2C8              ; D0 03
LA2C5:      rol                    ; 2A
            and #$EF               ; 29 EF
LA2C8:      sta CRITIC,X           ; 95 42
LA2CA:      lda CRITIC,X           ; B5 42
            and #$08               ; 29 08
            bne LA2DE              ; D0 0E
            lda L0516,X            ; BD 16 05
            clc                    ; 18
            adc #$01               ; 69 01
            cmp #$D5               ; C9 D5
            bcc LA2EA              ; 90 10
            lda #$2C               ; A9 2C
            bne LA2EA              ; D0 0C
LA2DE:      lda L0516,X            ; BD 16 05
            sec                    ; 38
            sbc #$01               ; E9 01
            cmp #$2C               ; C9 2C
            bcs LA2EA              ; B0 02
            lda #$D4               ; A9 D4
LA2EA:      sta L0516,X            ; 9D 16 05
LA2ED:      inx                    ; E8
LA2EE:      cpx #$0B               ; E0 0B
            bcs LA2F5              ; B0 03
            jmp LA271              ; 4C 71 A2
LA2F5:      ldx ICAX1Z             ; A6 2A
            beq LA312              ; F0 19
            lda DSKFMS             ; A5 18
            and #$07               ; 29 07
            bne LA312              ; D0 13
            dex                    ; CA
            bne LA310              ; D0 0E
            dex                    ; CA
            lda ICBLHZ             ; A5 29
            bmi LA310              ; 30 09
            ora #$80               ; 09 80
            sta ICBLHZ             ; 85 29
            stx ICAX1Z             ; 86 2A
            jmp LA688              ; 4C 88 A6
LA310:      stx ICAX1Z             ; 86 2A
LA312:      lda STICK_BUF           ; A5 19
            asl                    ; 0A
            asl                    ; 0A
            asl                    ; 0A
            asl                    ; 0A
            sta L00B9              ; 85 B9
            lda PORTA              ; AD 00 D3
            ldx DELTAC             ; A6 77
            beq LA325              ; F0 04
            lsr                    ; 4A
            lsr                    ; 4A
            lsr                    ; 4A
            lsr                    ; 4A
LA325:      and #$0F               ; 29 0F
            sta STICK_BUF           ; 85 19
            cmp #$0F               ; C9 0F
            bne LA332              ; D0 05
            lda TRIG0,X            ; BD 10 D0
            bne LA33F              ; D0 0D
LA332:      lda INGAME             ; A5 76
            sec                    ; 38
            sbc #$2F               ; E9 2F
            bne LA33F              ; D0 06
            sta INGAME             ; 85 76
            ldx #$40               ; A2 40
            stx CRAFT_SPEED           ; 86 59
LA33F:      ldx INGAME             ; A6 76
            bmi LA35C              ; 30 19
            bne LA348              ; D0 03
            jmp LA3E9              ; 4C E9 A3
LA348:      cpx #$30               ; E0 30
            bcc LA3B9              ; 90 6D
            bne LA358              ; D0 0A
            ldy #$80               ; A0 80
            sty L052C              ; 8C 2C 05
            ldy RAMTOP             ; A4 6A
            dey                    ; 88
            sty RAMTOP             ; 84 6A
LA358:      dec INGAME             ; C6 76
            bne LA3B9              ; D0 5D
LA35C:      inx                    ; E8
            beq LA3B9              ; F0 5A
            txa                    ; 8A
            and #$07               ; 29 07
            bne LA36A              ; D0 06
            ldy CRAFT_IND             ; A4 5E
            beq LA36A              ; F0 02
            dec CRAFT_IND             ; C6 5E
LA36A:      dec INGAME             ; C6 76
            bmi LA3B9              ; 30 4B
            lda ENDPT+1            ; A5 75
            beq LA375              ; F0 03
            jsr LB247              ; 20 47 B2
LA375:      lda #$01               ; A9 01
            sta KEYDEF             ; 85 79
            lda RAMTOP             ; A5 6A
            bne LA3BC              ; D0 3F
            lda #$63               ; A9 63
            jsr LB261              ; 20 61 B2
            lda #$6E               ; A9 6E
            jsr LB261              ; 20 61 B2
            lda BOOT               ; A5 09
            lsr                    ; 4A
            bcs LA392              ; B0 06
            jsr LB06E              ; 20 6E B0
            jmp LA3B1              ; 4C B1 A3
LA392:      lda DELTAC             ; A5 77
            beq LA399              ; F0 03
            jsr LB247              ; 20 47 B2
LA399:      ldx #$03               ; A2 03
LA39B:      lda LBB8F,X            ; BD 8F BB
            eor #$C0               ; 49 C0
            sta L1033,X            ; 9D 33 10
            dex                    ; CA
            bpl LA39B              ; 10 F5
            lda #$50               ; A9 50
            sta L00B1              ; 85 B1
            ldx #$6C               ; A2 6C
            ldy #$37               ; A0 37
            jsr LB064              ; 20 64 B0
LA3B1:      jsr LB21A              ; 20 1A B2
            lda #$20               ; A9 20
            sta L3FB3              ; 8D B3 3F
LA3B9:      jmp LA3E6              ; 4C E6 A3
LA3BC:      ldx #$12               ; A2 12
            jsr LB0F1              ; 20 F1 B0
LA3C1:      lda VCOUNT             ; AD 0B D4
            cmp #$50               ; C9 50
            bcc LA3C1              ; 90 F9
            lda MLTTMP             ; A5 66
            sta L00AA              ; 85 AA
            lda MLTTMP+1           ; A5 67
            sta L00AB              ; 85 AB
            lda SAVADR             ; A5 68
            sta L00AC              ; 85 AC
            lda SAVADR+1           ; A5 69
            sta LMARGN             ; 85 52
            clc                    ; 18
            adc #$26               ; 69 26
            adc ROWCRS             ; 65 54
            sta DINDEX             ; 85 57
            bit ICBLHZ             ; 24 29
            bpl LA3E6              ; 10 03
            jsr LB21A              ; 20 1A B2
LA3E6:      jmp LA5B7              ; 4C B7 A5
LA3E9:      ldx ABUFPT+1           ; A6 1D
            bmi LA424              ; 30 37
            lda L0500,X            ; BD 00 05
            cmp #$07               ; C9 07
            bcc LA424              ; 90 30
            cmp #$0E               ; C9 0E
            bcc LA3FC              ; 90 04
            bne LA40A              ; D0 10
            inc ICAX5Z             ; E6 2E
LA3FC:      ldy #$1F               ; A0 1F
            lda #$01               ; A9 01
            jsr LB1C0              ; 20 C0 B1
            ldx ABUFPT+1           ; A6 1D
            lda #$03               ; A9 03
            jmp LA4E0              ; 4C E0 A4
LA40A:      lda FUEL             ; A5 5B
            adc #$01               ; 69 01
            ldx #$04               ; A2 04
            bcc LA418              ; 90 06
            lda #$FF               ; A9 FF
            sta FUEL+1           ; 85 5C
            ldx #$03               ; A2 03
LA418:      sta FUEL             ; 85 5B
            cpx KEYDEF+1           ; E4 7A
            beq LA424              ; F0 06
            stx KEYDEF+1           ; 86 7A
            lda #$08               ; A9 08
            sta LOWFUELPITCH             ; 85 7B
LA424:      ldx ABUFPT+2           ; A6 1E
            bmi LA42E              ; 30 06
            ldx TANKMISSLHIND               ; A6 50
            cpx #$11               ; E0 11
            bcs LA436              ; B0 08
LA42E:      ldx ICDNOZ             ; A6 21
            bpl LA436              ; 10 04
            ldx DSKUTL+1           ; A6 1B
            bmi LA43F              ; 30 09
LA436:      ldy #$1F               ; A0 1F
            lda #$01               ; A9 01
LA43A:      jsr LB1C0              ; 20 C0 B1
            bne LA3E6              ; D0 A7
LA43F:      lda FUEL+1           ; A5 5C
            sec                    ; 38
            sbc #$20               ; E9 20
            bcs LA453              ; B0 0D
            ldy FUEL             ; A4 5B
            bne LA451              ; D0 07
            lda #$02               ; A9 02
            ldy #$23               ; A0 23
            jmp LA43A              ; 4C 3A A4
LA451:      dec FUEL             ; C6 5B
LA453:      sta FUEL+1           ; 85 5C
            ldx #$09               ; A2 09
            lda STICK_BUF           ; A5 19
            tay                    ; A8
            and #$0C               ; 29 0C
            eor #$0C               ; 49 0C
            bne LA466              ; D0 06
            sta ICAX2Z             ; 85 2B
            sta CRAFT_LRSPEED             ; 85 58
            beq LA495              ; F0 2F
LA466:      lda ICAX2Z             ; A5 2B
            clc                    ; 18
            adc #$08               ; 69 08
            bcs LA46F              ; B0 02
            sta ICAX2Z             ; 85 2B
LA46F:      dex                    ; CA
            tya                    ; 98
            and #$08               ; 29 08
            beq LA483              ; F0 0E
            dex                    ; CA
            bcs LA47F              ; B0 07
            lda CRAFT_LRSPEED             ; A5 58
            sec                    ; 38
            sbc ICAX2Z             ; E5 2B
            bcs LA493              ; B0 14
LA47F:      dec DINDEX             ; C6 57
            bne LA493              ; D0 10
LA483:      bcs LA491              ; B0 0C
            lda CRAFT_LRSPEED             ; A5 58
            bit L00B9              ; 24 B9
            bpl LA48D              ; 10 02
            lda #$FF               ; A9 FF
LA48D:      adc ICAX2Z             ; 65 2B
            bcc LA493              ; 90 02
LA491:      inc DINDEX             ; E6 57
LA493:      sta CRAFT_LRSPEED             ; 85 58
LA495:      stx CRAFT_IND             ; 86 5E
            ldx CRAFT_SPEED           ; A6 59
            tya                    ; 98
            lsr                    ; 4A
            bcs LA4A4              ; B0 07
LA49D:      txa                    ; 8A
            adc #$02               ; 69 02
            bcc LA4B4              ; 90 12
            bcs LA4B6              ; B0 12
LA4A4:      lsr                    ; 4A
            bcc LA4AD              ; 90 06
            txa                    ; 8A
            asl                    ; 0A
            bcc LA49D              ; 90 F2
            beq LA4B6              ; F0 09
LA4AD:      txa                    ; 8A
            cmp #$41               ; C9 41
            bcc LA4B6              ; 90 04
            sbc #$02               ; E9 02
LA4B4:      sta CRAFT_SPEED           ; 85 59
LA4B6:      ldx ABUFPT             ; A6 1C
            bmi LA4C1              ; 30 07
            ldy L0500,X            ; BC 00 05
            cpy #$07               ; C0 07
            bcs LA4DE              ; B0 1D
LA4C1:      ldx ABUFPT+3           ; A6 1F
            bmi LA4DB              ; 30 16
            ldy TANKMISSLHIND               ; A4 50
            cpy #$11               ; C0 11
            bcc LA4DB              ; 90 10
            ldy L0500,X            ; BC 00 05
            cpy #$08               ; C0 08
            bcc LA4DB              ; 90 09
            lda #$02               ; A9 02
            sta L0500,X            ; 9D 00 05
            lda #$17               ; A9 17
            sta EXPL_CNT             ; 85 7C
LA4DB:      jmp LA58D              ; 4C 8D A5
LA4DE:      lda #$02               ; A9 02
LA4E0:      sta L0500,X            ; 9D 00 05
            ldy L050B,X            ; BC 0B 05
            lda #$17               ; A9 17
            sta EXPL_CNT             ; 85 7C
            cpy #$0E               ; C0 0E
            bne LA547              ; D0 59
            sta CHKSUM             ; 85 31
            lda PALNTS             ; A5 62
            sed                    ; F8
            adc #$00               ; 69 00
            sta PALNTS             ; 85 62
            lda FKDEF+1            ; A5 61
            adc #$00               ; 69 00
            cld                    ; D8
            sta FKDEF+1            ; 85 61
            inc ICAX5Z             ; E6 2E
            lda L0516,X            ; BD 16 05
            sec                    ; 38
            sbc #$08               ; E9 08
            cmp RECVDN             ; C5 39
            bcs LA521              ; B0 17
            lda L0516,X            ; BD 16 05
            adc #$1F               ; 69 1F
            cmp RECVDN             ; C5 39
            bcc LA521              ; 90 0E
            lda TANK_IND             ; A5 38
            ora #$80               ; 09 80
            sta TANK_IND             ; 85 38
            lda #$37               ; A9 37
            sta EXPL_CNT             ; 85 7C
            ldy #$10               ; A0 10
            bne LA547              ; D0 26
LA521:      lda FKDEF+1            ; A5 61
            bne LA52B              ; D0 06
            lda PALNTS             ; A5 62
            cmp #$05               ; C9 05
            bcc LA547              ; 90 1C
LA52B:      lda TANK_IND             ; A5 38
            cmp #$06               ; C9 06
            bcs LA53C              ; B0 0B
            lda L0516,X            ; BD 16 05
            sec                    ; 38
            sbc RECVDN             ; E5 39
            cmp #$29               ; C9 29
            jmp LA543              ; 4C 43 A5
LA53C:      lda RECVDN             ; A5 39
            sbc L0516,X            ; FD 16 05
            cmp #$41               ; C9 41
LA543:      bcs LA547              ; B0 02
            inc TANKMISSLHIND               ; E6 50
LA547:      sed                    ; F8
            lda ADRESS             ; A5 64
            and #$F0               ; 29 F0
            sta L00B1              ; 85 B1
            lda LBB0B,Y            ; B9 0B BB
            clc                    ; 18
            adc ADRESS+1           ; 65 65
            sta ADRESS+1           ; 85 65
            lda ADRESS             ; A5 64
            adc #$00               ; 69 00
            sta ADRESS             ; 85 64
            lda LOGCOL             ; A5 63
            adc #$00               ; 69 00
            sta LOGCOL             ; 85 63
            cld                    ; D8
            bcc LA574              ; 90 0F
            lda #$99               ; A9 99
            sta LOGCOL             ; 85 63
            sta ADRESS             ; 85 64
            sta ADRESS+1           ; 85 65
            lda #$00               ; A9 00
            sta RAMTOP             ; 85 6A
            jmp LA436              ; 4C 36 A4
LA574:      lda ADRESS             ; A5 64
            and #$F0               ; 29 F0
            cmp L00B1              ; C5 B1
            beq LA589              ; F0 0D
            ldy RAMTOP             ; A4 6A
            cpy #$09               ; C0 09
            beq LA589              ; F0 07
            iny                    ; C8
            sty RAMTOP             ; 84 6A
            lda #$40               ; A9 40
            sta COUNTR             ; 85 7E
LA589:      ldx #$01               ; A2 01
            bne LA5AA              ; D0 1D
LA58D:      lda DSKUTL             ; A5 1A
            bpl LA589              ; 10 F8
            lda MISSILEVPOS           ; A5 56
            cmp #$1C               ; C9 1C
            bcc LA59D              ; 90 06
            sbc #$04               ; E9 06
            tax                    ; AA
            jmp LA5AA              ; 4C AA A5
LA59D:      ldx DELTAC             ; A6 77
            lda TRIG0,X            ; BD 10 D0
            bne LA589              ; D0 E5
            ldx #$0F               ; A2 0F
            stx CRMISSL_CNT             ; 86 7D
            ldx #$A9               ; A2 A9
LA5AA:      txa                    ; 8A
            pha                    ; 48
            jsr CLR_MISSL              ; 20 21 B2
            pla                    ; 68
            sta MISSILEVPOS           ; 85 56
            lda #$30               ; A9 20
            jsr DRAW_MISSL              ; 20 23 B2
LA5B7:      ldy #$00               ; A0 00
            ldx HOLD1              ; A6 51
            cpx #$0B               ; E0 0B
            bcs LA605              ; B0 46
            lda L0500,X            ; BD 00 05
            cmp #$0A               ; C9 0A
            beq LA5CA              ; F0 04
            cmp #$0B               ; C9 0B
            bne LA605              ; D0 3B
LA5CA:      lda L00C1              ; A5 C1
            bne LA5FD              ; D0 2F
            bit ICBLHZ             ; 24 29
            bmi LA5D6              ; 30 04
            lda INGAME             ; A5 76
            bne LA605              ; D0 2F
LA5D6:      lda DOSINI,X           ; B5 0C
            sbc #$3C               ; E9 3C
            cmp #$1C               ; C9 1C
            bcc LA607              ; 90 29
            sta L00C2              ; 85 C2
            lda #$09               ; A9 09
            sta COUNTR+1           ; 85 7F
            ldy L0516,X            ; BC 16 05
            dey                    ; 88
            dey                    ; 88
            dey                    ; 88
            lda CRITIC,X           ; B5 42
            ldx #$FE               ; A2 FE
            and #$08               ; 29 08
            bne LA5F8              ; D0 06
            ldx #$02               ; A2 02
            tya                    ; 98
            adc #$09               ; 69 09
            tay                    ; A8
LA5F8:      stx L00C0              ; 86 C0
            jmp LA605              ; 4C 05 A6
LA5FD:      ldx ICCOMZ             ; A6 22
            bpl LA605              ; 10 04
            clc                    ; 18
            adc L00C0              ; 65 C0
            tay                    ; A8
LA605:      sty L00C1              ; 84 C1
LA607:      ldy #$00               ; A0 00
            lda TANKMISSLHIND               ; A5 50
            bmi LA671              ; 30 64
            bne LA62A              ; D0 1B
            lda XMTDON             ; A5 3A
            cmp #$19               ; C9 19
            bcc LA671              ; 90 5C
            sbc #$03               ; E9 06
            sta TANKMISSLVPOS               ; 85 40
            sty BPTR               ; 84 3D
            lda RECVDN             ; A5 39
            ldx TANK_IND             ; A6 38
            cpx #$06               ; E0 06
            bcs LA625              ; B0 02
            adc #$09               ; 69 09
LA625:      sbc #$04               ; E9 04
            jmp LA652              ; 4C 52 A6
LA62A:      tax                    ; AA
            sec                    ; 38
            sbc #$11               ; E9 11
            bcs LA657              ; B0 27
            lda TANKMISSLVPOS               ; A5 40
            adc LB4B0-1,X            ; 7D AF B4
            sta TANKMISSLVPOS               ; 85 40
            lda BPTR               ; A5 3D
            ldx TANK_IND             ; A6 38
            cpx #$06               ; E0 06
            bcs LA64A              ; B0 0B
            adc FEOF               ; 65 3F
            sta BPTR               ; 85 3D
            lda NOCKSM             ; A5 3C
            adc FTYPE              ; 65 3E
            jmp LA652              ; 4C 52 A6
LA64A:      sbc FEOF               ; E5 3F
            sta BPTR               ; 85 3D
            lda NOCKSM             ; A5 3C
            sbc FTYPE              ; E5 3E
LA652:      sta NOCKSM             ; 85 3C
            iny                    ; C8
            bne LA65E              ; D0 07
LA657:      lsr                    ; 4A
            lsr                    ; 4A
            lsr                    ; 4A
            clc                    ; 18
            adc #$02               ; 69 02
            tay                    ; A8
LA65E:      ldx TANKMISSLHIND               ; A6 50
            inx                    ; E8
            cpx #$39               ; E0 39
            bcc LA66F              ; 90 0A
            ldx #$00               ; A2 00
            ldy #$00               ; A0 00
            lda INGAME             ; A5 76
            beq LA66F              ; F0 02
            ldx #$FF               ; A2 FF
LA66F:      stx TANKMISSLHIND               ; 86 50
LA671:      sty CHKSNT             ; 84 3B
            ldy #$00               ; A0 00
            lda #$08               ; A9 08
            sta CONSOL             ; 8D 1F D0
            lda CONSOL             ; AD 1F D0
            lsr                    ; 4A
            bcs LA693              ; B0 13
            lda #$02               ; A9 02
            sta L00C6              ; 85 C6
            sty ICBLHZ             ; 84 29
            sty ICAX1Z             ; 84 2A
LA688:      lda BOOT               ; A5 09
            and #$01               ; 29 01
            sta DELTAC             ; 85 77
            ldx #$79               ; A2 79
            jmp LA15D              ; 4C 5D A1
LA693:      lsr                    ; 4A
            bcc LA699              ; 90 03
            lsr                    ; 4A
            bcs LA6DC              ; B0 43
LA699:      dec ICBAHZ             ; C6 25
            bpl LA6DE              ; 10 41
            ldx BOOT               ; A6 09
            inx                    ; E8
            cpx #$08               ; E0 08
            bcc LA6A6              ; 90 02
            ldx #$00               ; A2 00
LA6A6:      stx BOOT               ; 86 09
            txa                    ; 8A
            clc                    ; 18
            adc #$D1               ; 69 D1
            sty L102A              ; 8C 2A 10
            sta L102B              ; 8D 2B 10
            lda #$00               ; A9 00
            sta DELTAC+1           ; 85 78
            sta ICBLHZ             ; 85 29
            sta RAMTOP             ; 85 6A
            sta ENDPT+1            ; 85 75
            sta DELTAC             ; 85 77
            ldx #$02               ; A2 02
            stx L00C6              ; 86 C6
LA6C2:      sta LOGCOL,X           ; 95 63
            sta BITMSK,X           ; 95 6E
            dex                    ; CA
            bpl LA6C2              ; 10 F9
            sta COUNTR+1           ; 85 7F
            stx TANKMISSLHIND               ; 86 50
            jsr LAF80              ; 20 80 AF
            jsr LAF5B              ; 20 5B AF
            jsr LB21A              ; 20 1A B2
            ldx #$25               ; A2 25
            stx ICAX1Z             ; 86 2A
            ldy #$1E               ; A0 1E
LA6DC:      sty ICBAHZ             ; 84 25
LA6DE:      lda INGAME             ; A5 76
            bmi LA6ED              ; 30 0B
            cmp #$2F               ; C9 2F
            bne LA6FD              ; D0 17
            lda #$09               ; A9 09
            sta CRAFT_IND             ; 85 5E
LA6EA:      jmp LAE99              ; 4C 99 AE
LA6ED:      bit ICBLHZ             ; 24 29
            bpl LA6EA              ; 10 F9
            lda #$80               ; A9 80
            ldx BOOT               ; A6 09
            cpx #$04               ; E0 04
            bcc LA6FB              ; 90 02
            lda #$FE               ; A9 FE
LA6FB:      sta CRAFT_SPEED           ; 85 59
LA6FD:      lda #$02               ; A9 02
            sta L00A9              ; 85 A9
LA701:      dec L00A9              ; C6 A9
            bmi LA6EA              ; 30 E5
            lda CRAFT_SPEED           ; A5 59
            cmp #$FE               ; C9 FE
            bcs LA711              ; B0 06
            adc STATUS             ; 65 30
            sta STATUS             ; 85 30
            bcc LA701              ; 90 F0
LA711:      ldy #$00               ; A0 00
            lda FKDEF              ; A5 60
            cmp #$09               ; C9 09
            bcs LA71B              ; B0 02
            ldy #$06               ; A0 06
LA71B:      sty L00B5              ; 84 B5
            inc ICAX6Z             ; E6 2F
            lda ICAX6Z             ; A5 2F
            cmp #$20               ; C9 20
            bcs LA72B              ; B0 06
            bit ICSTAZ             ; 24 23
            bpl LA756              ; 10 2D
            bmi LA759              ; 30 2E
LA72B:      ldx #$00               ; A2 00
            stx ICAX6Z             ; 86 2F
            stx LTEMP              ; 86 36
            stx L052D              ; 8E 2D 05
            lda ICSTAZ             ; A5 23
            and #$04               ; 29 04
            ora #$10               ; 09 10
            sta ICSTAZ             ; 85 23
            ldx OLD_ADR_HI           ; A6 5F
            stx ICAX3Z             ; 86 2C
            dec OLDROW             ; C6 5A
            beq LA75C              ; F0 18
            ldx OLDCHR             ; A6 5D
            dex                    ; CA
            bne LA756              ; D0 0D
            stx ICAX5Z             ; 86 2E
            lda FKDEF              ; A5 60
            lsr                    ; 4A
            lda #$80               ; A9 80
            bcs LA754              ; B0 02
            lda #$84               ; A9 84
LA754:      sta ICSTAZ             ; 85 23
LA756:      jsr LB183              ; 20 83 B1
LA759:      jmp LA7FB              ; 4C FB A7
LA75C:      dec OLDCHR             ; C6 5D
            bne LA767              ; D0 07
	    ; IF COMMENTED OUT NO PLANES AND BACK ISSUES
            jsr LB194              ; 20 94 B1
            ldx #$10               ; A2 10
            stx OLDCHR             ; 86 5D
LA767:      jsr LB183              ; 20 83 B1
            ldx OLDCHR             ; A6 5D
            dex                    ; CA
            bne LA781              ; D0 12
            stx ICAX4Z             ; 86 2D
            lda #$0D               ; A9 0D
            sta OLD_ADR_HI           ; 85 5F
            lda FKDEF              ; A5 60
            lsr                    ; 4A
            bcc LA77D              ; 90 03
            dec L052D              ; CE 2D 05
LA77D:      lda #$36               ; A9 36
            bne LA7E0              ; D0 5F
LA781:      lda FKDEF              ; A5 60
            lsr                    ; 4A
            lda #$07               ; A9 07
            bcs LA7DC              ; B0 54
            lda ICAX4Z             ; A5 2D
            dex                    ; CA
            bne LA793              ; D0 06
            cmp #$C0               ; C9 C0
            beq LA79E              ; F0 0D
            bne LA7B2              ; D0 1F
LA793:      asl                    ; 0A
            eor ICAX4Z             ; 45 2D
            bmi LA7AC              ; 30 14
            lda L00AA              ; A5 AA
            and #$30               ; 29 30
            bne LA7B6              ; D0 18
LA79E:      lda ICAX4Z             ; A5 2D
            and #$80               ; 29 80
            bne LA7A6              ; D0 02
            ora #$40               ; 09 40
LA7A6:      sta ICAX4Z             ; 85 2D
            lda #$00               ; A9 00
            beq LA7DC              ; F0 30
LA7AC:      lda #$C0               ; A9 C0
            bit ICAX4Z             ; 24 2D
            bvs LA7B4              ; 70 02
LA7B2:      lda #$00               ; A9 00
LA7B4:      sta ICAX4Z             ; 85 2D
LA7B6:      ldy #$0F               ; A0 0F
            lda L00AA              ; A5 AA
            and #$0F               ; 29 0F
            cmp #$02               ; C9 02
            bcs LA7C2              ; B0 02
            adc #$02               ; 69 02
LA7C2:      bit ICAX4Z             ; 24 2D
            bpl LA7C7              ; 10 01
            dey                    ; 88
LA7C7:      ldx FKDEF              ; A6 60
            cpx #$14               ; E0 14
            bcs LA7CE              ; B0 01
            dey                    ; 88
LA7CE:      ldx L00B5              ; A6 B5
            beq LA7D4              ; F0 02
            ldy #$08               ; A0 08
LA7D4:      sty L00B1              ; 84 B1
            cmp L00B1              ; C5 B1
            bcc LA7DC              ; 90 02
            lda L00B1              ; A5 B1
LA7DC:      sta OLD_ADR_HI           ; 85 5F
            asl                    ; 0A
            asl                    ; 0A
LA7E0:      ldy #$02               ; A0 02
            sty OLDROW             ; 84 5A
            sta BFENLO             ; 85 34
            sec                    ; 38
            sbc ROWCRS             ; E5 54
            beq LA7FB              ; F0 10
            bcc LA7F3              ; 90 06
            cmp #$20               ; C9 20
            lda #$01               ; A9 01
            bne LA7F7              ; D0 04
LA7F3:      cmp #$E0               ; C9 E0
            lda #$FE               ; A9 FE
LA7F7:      adc #$00               ; 69 00
            sta BFENHI             ; 85 35
LA7FB:      lda BFENHI             ; A5 35
            beq LA826              ; F0 27
            bpl LA809              ; 10 08
            lda BFENLO             ; A5 34
            cmp ROWCRS             ; C5 54
            bcs LA80F              ; B0 08
            bcc LA815              ; 90 0C
LA809:      lda ROWCRS             ; A5 54
            cmp BFENLO             ; C5 34
            bcc LA815              ; 90 06
LA80F:      lda #$00               ; A9 00
            sta BFENHI             ; 85 35
            beq LA826              ; F0 11
LA815:      lda ROWCRS             ; A5 54
            clc                    ; 18
            adc BFENHI             ; 65 35
            sta ROWCRS             ; 85 54
            lda RMARGN             ; A5 53
            sec                    ; 38
            sbc BFENHI             ; E5 35
            sec                    ; 38
            sbc BFENHI             ; E5 35
            sta RMARGN             ; 85 53
LA826:      bit ICSTAZ             ; 24 23
            bpl LA83A              ; 10 10
            lda #$00               ; A9 00
            sta L00C3              ; 85 C3
            ldx ICAX6Z             ; A6 2F
            lda LBA8F,X            ; BD 8F BA
            clc                    ; 18
            adc LMARGN             ; 65 52
            tax                    ; AA
LA837:      jmp LA96A              ; 4C 6A A9
LA83A:      lda L052D              ; AD 2D 05
            beq LA84F              ; F0 10
            ldx LMARGN             ; A6 52
            cpx #$18               ; E0 18
            bcs LA848              ; B0 03
            inx                    ; E8
            bne LA837              ; D0 EF
LA848:      cpx #$29               ; E0 29
            bcc LA84F              ; 90 03
            dex                    ; CA
            bne LA837              ; D0 E8
LA84F:      ldx #$01               ; A2 01
            ldy #$40               ; A0 40
            lda FKDEF              ; A5 60
            cmp #$03               ; C9 03
            bcs LA85F              ; B0 06
            ldx #$1C               ; A2 1C
            ldy #$24               ; A0 24
            bne LA885              ; D0 26
LA85F:      lsr                    ; 4A
            bcc LA86D              ; 90 0B
            lda L052D              ; AD 2D 05
            bne LA86D              ; D0 06
            lda FKDEF              ; A5 60
            cmp #$0A               ; C9 0A
            bcs LA871              ; B0 04
LA86D:      ldy #$28               ; A0 28
            bne LA883              ; D0 12
LA871:      cmp #$14               ; C9 14
            bcs LA879              ; B0 04
            ldx #$0D               ; A2 0D
            ldy #$34               ; A0 34
LA879:      lda LTEMP              ; A5 36
            beq LA885              ; F0 08
            bmi LA883              ; 30 04
            ldy #$28               ; A0 28
            bne LA885              ; D0 02
LA883:      ldx #$19               ; A2 19
LA885:      stx L00C4              ; 86 C4
            sty L00C5              ; 84 C5
            lda L00AC              ; A5 AC
            and #$0F               ; 29 0F
            ldy L00C3              ; A4 C3
            bne LA89E              ; D0 0D
            cmp #$08               ; C9 08
            lda #$01               ; A9 01
            bcs LA899              ; B0 02
            lda #$FF               ; A9 FF
LA899:      sta L00C3              ; 85 C3
            jmp LA8C4              ; 4C C4 A8
LA89E:      cmp #$08               ; C9 08
            bcs LA8A5              ; B0 03
LA8A2:      jmp LA96C              ; 4C 6C A9
LA8A5:      cmp #$0D               ; C9 0D
            bne LA8B1              ; D0 08
            lda L00C3              ; A5 C3
            eor #$FE               ; 49 FE
            sta L00C3              ; 85 C3
            bne LA8C4              ; D0 13
LA8B1:      cmp #$0F               ; C9 0F
            bne LA8C4              ; D0 0F
            ldx #$0E               ; A2 0E
            bit ICAX4Z             ; 24 2D
            bpl LA8BC              ; 10 01
            dex                    ; CA
LA8BC:      cpx OLD_ADR_HI           ; E4 5F
            bcc LA8A2              ; 90 E2
            cpx ICAX3Z             ; E4 2C
            bcc LA8A2              ; 90 DE
LA8C4:      lda ROWCRS             ; A5 54
            cmp BFENLO             ; C5 34
            bcs LA8CC              ; B0 02
            lda BFENLO             ; A5 34
LA8CC:      sta L00C9              ; 85 C9
            lda #$40               ; A9 40
            sec                    ; 38
            sbc L00C9              ; E5 C9
            asl                    ; 0A
            sta L00C8              ; 85 C8
            ldx DRKMSK             ; A6 4E
            lda L00C3              ; A5 C3
            bpl LA929              ; 10 4D
            lda LMARGN             ; A5 52
            cmp L00C4              ; C5 C4
            bcs LA8E5              ; B0 03
            jmp LA95F              ; 4C 5F A9
LA8E5:      cpx #$0B               ; E0 0B
            bcs LA923              ; B0 3A
            lda L050B,X            ; BD 0B 05
            cmp #$08               ; C9 08
            bcc LA923              ; 90 33
            lda LMARGN             ; A5 52
            bit ICAX4Z             ; 24 2D
            bpl LA906              ; 10 10
            bit LTEMP+1            ; 24 37
            bpl LA8FE              ; 10 04
            adc #$7F               ; 69 7F
            bne LA90C              ; D0 0E
LA8FE:      lda L00C8              ; A5 C8
            lsr                    ; 4A
            clc                    ; 18
            adc LMARGN             ; 65 52
            bne LA90C              ; D0 06
LA906:      clc                    ; 18
            adc L00C8              ; 65 C8
            clc                    ; 18
            adc L00C9              ; 65 C9
LA90C:      sta L00B7              ; 85 B7
            lda L0516,X            ; BD 16 05
            sec                    ; 38
            sbc #$17               ; E9 17
            clc                    ; 18
            adc L00B5              ; 65 B5
            ldy L0521,X            ; BC 21 05
            beq LA91F              ; F0 03
            clc                    ; 18
            adc #$08               ; 69 08
LA91F:      cmp L00B7              ; C5 B7
            bcs LA95F              ; B0 3C
LA923:      ldx LMARGN             ; A6 52
            dex                    ; CA
            jmp LA96A              ; 4C 6A A9
LA929:      lda LMARGN             ; A5 52
            cmp L00C5              ; C5 C5
            bcs LA95F              ; B0 30
            cpx #$0B               ; E0 0B
            bcs LA967              ; B0 34
            lda L050B,X            ; BD 0B 05
            cmp #$08               ; C9 08
            bcc LA967              ; 90 2D
            lda LMARGN             ; A5 52
            bit ICAX4Z             ; 24 2D
            bpl LA94A              ; 10 0A
            bit LTEMP+1            ; 24 37
            bpl LA94D              ; 10 09
            adc #$3F               ; 69 3F
            adc L00C9              ; 65 C9
            bne LA94D              ; D0 03
LA94A:      clc                    ; 18
            adc L00C9              ; 65 C9
LA94D:      clc                    ; 18
            adc #$02               ; 69 02
            sta L00B7              ; 85 B7
            lda L0516,X            ; BD 16 05
            sec                    ; 38
            sbc #$20               ; E9 20
            sec                    ; 38
            sbc L00B5              ; E5 B5
            cmp L00B7              ; C5 B7
            bcs LA967              ; B0 08
LA95F:      lda L00C3              ; A5 C3
            eor #$FE               ; 49 FE
            sta L00C3              ; 85 C3
            bne LA96C              ; D0 05
LA967:      ldx LMARGN             ; A6 52
            inx                    ; E8
LA96A:      stx LMARGN             ; 86 52
LA96C:      bit ICSTAZ             ; 24 23
            bmi LA9D7              ; 30 67
            lda ICAX6Z             ; A5 2F
            bne LA9D7              ; D0 63
            lda L00AC              ; A5 AC
            and #$20               ; 29 20
            beq LA9D7              ; F0 5D
            lda FKDEF              ; A5 60
            lsr                    ; 4A
            bcc LA989              ; 90 0A
            lda L00AA              ; A5 AA
            and #$07               ; 29 07
            tax                    ; AA
            lda LBBCC,X            ; BD CC BB
            bpl LA9A4              ; 10 1B
LA989:      ldx OLD_ADR_HI           ; A6 5F
            cpx ICAX3Z             ; E4 2C
            bcc LA991              ; 90 02
            ldx ICAX3Z             ; A6 2C
LA991:      cpx #$02               ; E0 02
            bcc LA9D7              ; 90 42
            bit ICAX4Z             ; 24 2D
            bpl LA9A1              ; 10 08
            cpx #$05               ; E0 05
            bcc LA9D7              ; 90 3A
            txa                    ; 8A
            adc #$0A               ; 69 0A
            tax                    ; AA
LA9A1:      lda LBBD4,X            ; BD D4 BB
LA9A4:      sta L00BD              ; 85 BD
            lda MOUNTAINWIDTHS,X            ; BD B2 BB
            sta CURRMOUNTWIDTH              ; 85 BC
            tax                    ; AA
            lda LBBEB,X            ; BD EB BB
            sta L00BE              ; 85 BE
            ldy LMARGN             ; A4 52
            lda L00AC              ; A5 AC
            and #$80               ; 29 80
            bmi LA9BF              ; 30 06
            cpy #$29               ; C0 29
            bcc LA9C5              ; 90 08
            bcs LA9C3              ; B0 04
LA9BF:      cpy #$18               ; C0 18
            bcs LA9C5              ; B0 02
LA9C3:      eor #$80               ; 49 80
LA9C5:      clc                    ; 18
            adc #$01               ; 69 01
            sta LTEMP              ; 85 36
            txa                    ; 8A
            asl                    ; 0A
            tax                    ; AA
            lda LBBF0,X            ; BD F0 BB
            sta L00BA              ; 85 BA
            lda LBBF1,X            ; BD F1 BB
            sta L00BB              ; 85 BB
LA9D7:      lda L3F04              ; AD 04 3F
            sec                    ; 38
            sbc #$30               ; E9 30
            sta L3F04              ; 8D 04 3F
            bcs LA9F4              ; B0 12
            ldx L3F05              ; AE 05 3F
            dex                    ; CA
            cpx #$20               ; E0 20
            bcs LA9EC              ; B0 02
            ldx #$3E               ; A2 3E
LA9EC:      cpx #$2F               ; E0 2F
            bne LA9F1              ; D0 01
            dex                    ; CA
LA9F1:      stx L3F05              ; 8E 05 3F
LA9F4:      ldy L00A7              ; A4 A7
            beq LAA05              ; F0 0D
            ldy #$00               ; A0 00
            sty L3F07              ; 8C 07 3F
            sty L00A7              ; 84 A7
            jsr LB0C7              ; 20 C7 B0
            jmp LAA7A              ; 4C 7A AA
LAA05:      ldy L00A8              ; A4 A8
            beq LAA16              ; F0 0D
            ldy #$00               ; A0 00
            sty L3F07              ; 8C 07 3F
            sty L00A8              ; 84 A8
            jsr LB0D8              ; 20 D8 B0
            jmp LAA7A              ; 4C 7A AA
LAA16:      lda L00A5              ; A5 A5
            cmp #$A2               ; C9 A2
            bcc LAA45              ; 90 29
            lda #$02               ; A9 02
            sta L00A5              ; 85 A5
            lda #$0E               ; A9 0E
            sta L00A7              ; 85 A7
            sta L3FA6              ; 8D A6 3F
            sta L3FA7              ; 8D A7 3F
            sta L3FA8              ; 8D A8 3F
            ldx #$4E               ; A2 4E
            stx L3F06              ; 8E 06 3F
            ldx #$30               ; A2 30
            stx L3F07              ; 8E 07 3F
            ldx #$20               ; A2 20
            stx L3F08              ; 8E 08 3F
            jsr LB0C7              ; 20 C7 B0
            jsr LB0C7              ; 20 C7 B0
            jmp LAA77              ; 4C 77 AA
LAA45:      jsr LB0D8              ; 20 D8 B0
            lda L00A6              ; A5 A6
            cmp #$A2               ; C9 A2
            bcc LAA77              ; 90 29
            lda #$02               ; A9 02
            sta L00A6              ; 85 A6
            lda #$0E               ; A9 0E
            sta L00A8              ; 85 A8
            sta L3FA6              ; 8D A6 3F
            sta L3FA7              ; 8D A7 3F
            sta L3FA8              ; 8D A8 3F
            ldx #$4E               ; A2 4E
            stx L3F06              ; 8E 06 3F
            ldx #$30               ; A2 30
            stx L3F07              ; 8E 07 3F
            ldx #$30               ; A2 30
            stx L3F08              ; 8E 08 3F
            jsr LB0D8              ; 20 D8 B0
            jsr LB0D8              ; 20 D8 B0
            jmp LAA7A              ; 4C 7A AA
LAA77:      jsr LB0C7              ; 20 C7 B0
LAA7A:      lda #$B8               ; A9 B8
            sta L00A2              ; 85 A2
            lda L3F04              ; AD 04 3F
            sta L00A3              ; 85 A3
            lda L3F05              ; AD 05 3F
            sta L00A4              ; 85 A4
            lda #$00               ; A9 00
            sta L00B4              ; 85 B4
            lda LMARGN             ; A5 52
            bit ICAX4Z             ; 24 2D
            bmi LAA95              ; 30 03
            clc                    ; 18
            adc ROWCRS             ; 65 54
LAA95:      tax                    ; AA
            lsr                    ; 4A
            lsr                    ; 4A
            tay                    ; A8
            dey                    ; 88
            bit ICAX4Z             ; 24 2D
            bmi LAAB9              ; 30 1B
            lda LTEMP              ; A5 36
            bpl LAAB9              ; 10 17
            lda ICAX6Z             ; A5 2F
            cmp L00BE              ; C5 BE
            bcs LAAB9              ; B0 11
            tya                    ; 98
            pha                    ; 48
            ldy L00BD              ; A4 BD
            jsr LAFF4              ; 20 F4 AF
            jsr LB01A              ; 20 1A B0
            pla                    ; 68
            sec                    ; 38
            sbc CURRMOUNTWIDTH              ; E5 BC
            sbc L00BD              ; E5 BD
            tay                    ; A8
LAAB9:      jsr LAFF4              ; 20 F4 AF
            jsr LB034              ; 20 34 B0
            lda RMARGN             ; A5 53
            bit ICAX4Z             ; 24 2D
            bpl LAB37              ; 10 72
            ldy ROWCRS             ; A4 54
            cpy #$06               ; C0 06
            bcs LAAD2              ; B0 07
            adc ROWCRS             ; 65 54
            adc ROWCRS             ; 65 54
            jmp LAB37              ; 4C 37 AB
LAAD2:      stx L00B7              ; 86 B7
            lsr                    ; 4A
            clc                    ; 18
            adc L00B7              ; 65 B7
            tax                    ; AA
            lsr                    ; 4A
            lsr                    ; 4A
            sec                    ; 38
            sbc L00B4              ; E5 B4
            tay                    ; A8
            jsr LAFF0              ; 20 F0 AF
            adc #$02               ; 69 02
            ldy ROWCRS             ; A4 54
            cpy #$08               ; C0 08
            bcs LAAEC              ; B0 02
            adc #$10               ; 69 10
LAAEC:      jsr LB03B              ; 20 3B B0
            stx L00B7              ; 86 B7
            lda ROWCRS             ; A5 54
            asl                    ; 0A
            adc L00B7              ; 65 B7
            tax                    ; AA
            lsr                    ; 4A
            lsr                    ; 4A
            sec                    ; 38
            sbc L00B4              ; E5 B4
            tay                    ; A8
            dey                    ; 88
            lda ROWCRS             ; A5 54
            cmp #$08               ; C9 08
            bcs LAB0C              ; B0 08
            jsr LAFEC              ; 20 EC AF
            clc                    ; 18
            adc #$10               ; 69 10
            bne LAB31              ; D0 25
LAB0C:      lda LTEMP              ; A5 36
            beq LAB2E              ; F0 1E
            lda ICAX6Z             ; A5 2F
            cmp L00BE              ; C5 BE
            bcs LAB2E              ; B0 18
            lda L00BD              ; A5 BD
            sec                    ; 38
            sbc L00B4              ; E5 B4
            sta L00B7              ; 85 B7
            tya                    ; 98
            sec                    ; 38
            sbc L00B7              ; E5 B7
            sbc CURRMOUNTWIDTH              ; E5 BC
            pha                    ; 48
            ldy L00B7              ; A4 B7
            jsr LAFF4              ; 20 F4 AF
            jsr LB01A              ; 20 1A B0
            pla                    ; 68
            tay                    ; A8
LAB2E:      jsr LAFF4              ; 20 F4 AF
LAB31:      jsr LB03B              ; 20 3B B0
            lda RMARGN             ; A5 53
            lsr                    ; 4A
LAB37:      stx L00B7              ; 86 B7
            clc                    ; 18
            adc L00B7              ; 65 B7
            tax                    ; AA
            lsr                    ; 4A
            lsr                    ; 4A
            sec                    ; 38
            sbc L00B4              ; E5 B4
            tay                    ; A8
            jsr LAFF0              ; 20 F0 AF
            adc #$02               ; 69 02
            jsr LB034              ; 20 34 B0
            lda #$30               ; A9 30
            sec                    ; 38
            sbc L00B4              ; E5 B4
            tay                    ; A8
            bit ICAX4Z             ; 24 2D
            bmi LAB73              ; 30 1E
            lda LTEMP              ; A5 36
            beq LAB73              ; F0 1A
            bmi LAB73              ; 30 18
            lda ICAX6Z             ; A5 2F
            cmp L00BE              ; C5 BE
            bcs LAB73              ; B0 12
            tya                    ; 98
            sec                    ; 38
            sbc L00BD              ; E5 BD
            sbc CURRMOUNTWIDTH              ; E5 BC
            tay                    ; A8
            iny                    ; C8
            jsr LAFF4              ; 20 F4 AF
            jsr LB01A              ; 20 1A B0
            lda L00BD              ; A5 BD
            tay                    ; A8
            dey                    ; 88
LAB73:      jsr LAFF4              ; 20 F4 AF
            lda COLRSH             ; A5 4F
            beq LAB7C              ; F0 02
            dec COLRSH             ; C6 4F
LAB7C:      inc XMTDON             ; E6 3A
            inc TANKMISSLVPOS               ; E6 40
            inc L00C2              ; E6 C2
            inc DOSINI             ; E6 0C
            inc DOSINI+1           ; E6 0D
            inc APPMHI             ; E6 0E
            inc APPMHI+1           ; E6 0F
            inc POKMSK             ; E6 10
            inc BRKKEY             ; E6 11
            inc RTCLOK             ; E6 12
            inc RTCLOK+1           ; E6 13
            inc RTCLOK+2           ; E6 14
            inc BUFADR             ; E6 15
            inc BUFADR+1           ; E6 16
            bne LABE1              ; D0 47
            ldx ATRACT             ; A6 4D
            cpx #$0B               ; E0 0B
            bcs LABE1              ; B0 41
            ldx #$09               ; A2 09
LABA2:      lda DOSINI,X           ; B5 0C
            sta DOSINI+1,X         ; 95 0D
            lda L0516,X            ; BD 16 05
            sta L0517,X            ; 9D 17 05
            lda CRITIC,X           ; B5 42
            sta FMSZPG,X           ; 95 43
            lda L0500,X            ; BD 00 05
            sta L0501,X            ; 9D 01 05
            lda L050B,X            ; BD 0B 05
            sta L050C,X            ; 9D 0C 05
            lda L0521,X            ; BD 21 05
            sta L0522,X            ; 9D 22 05
            dex                    ; CA
            bmi LABC9              ; 30 04
            cpx ATRACT             ; E4 4D
            bcs LABA2              ; B0 D9
LABC9:      lda BUFRHI             ; A5 33
            eor #$01               ; 49 01
            sta BUFRHI             ; 85 33
            inc ATRACT             ; E6 4D
            ldx HOLD1              ; A6 51
            cpx #$0B               ; E0 0B
            bcs LABD9              ; B0 02
            inc HOLD1              ; E6 51
LABD9:      ldx DRKMSK             ; A6 4E
            cpx #$0B               ; E0 0B
            bcs LABE1              ; B0 02
            inc DRKMSK             ; E6 4E
LABE1:      ldx DRKMSK             ; A6 4E
            cpx #$0B               ; E0 0B
            bcs LABF3              ; B0 0C
            ldy BUFRLO             ; A4 32
            dey                    ; 88
            bmi LABEF              ; 30 03
            jmp LAE94              ; 4C 94 AE
LABEF:      ldy #$0B               ; A0 0B
            sty DRKMSK             ; 84 4E
LABF3:      lda ICAX6Z             ; A5 2F
            and #$0F               ; 29 0F
            bne LABFD              ; D0 04
            ldx ATRACT             ; A6 4D
            bne LAC00              ; D0 03
LABFD:      jmp LAE96              ; 4C 96 AE
LAC00:      dex                    ; CA
            stx ATRACT             ; 86 4D
            stx DRKMSK             ; 86 4E
            lda #$00               ; A9 00
            sta L00B8              ; 85 B8
            lda ICSTAZ             ; A5 23
            sta CRITIC,X           ; 95 42
            bpl LAC23              ; 10 14
            and #$04               ; 29 04
            ora #$D2               ; 09 D2
            sta DOSVEC+1           ; 85 0B
            lda #$07               ; A9 07
            sta L00B8              ; 85 B8
            ldy #$0E               ; A0 0E
            lda ROWCRS             ; A5 54
            sec                    ; 38
            sbc #$06               ; E9 06
            jmp LAD37              ; 4C 37 AD
LAC23:      ldy #$01               ; A0 01
            lda ICAX6Z             ; A5 2F
            beq LAC3E              ; F0 15
            lda FKDEF              ; A5 60
            sec                    ; 38
            sbc #$08               ; E9 08
            bmi LAC3B              ; 30 0B
            cmp #$20               ; C9 20
            bcs LAC62              ; B0 2E
            asl                    ; 0A
            asl                    ; 0A
            asl                    ; 0A
            cmp L00AB              ; C5 AB
            bcs LAC62              ; B0 27
LAC3B:      jmp LAD37              ; 4C 37 AD
LAC3E:      dey                    ; 88
            lda OLDCHR             ; A5 5D
            clc                    ; 18
            adc OLDROW             ; 65 5A
            cmp #$12               ; C9 12
            bcs LAC3B              ; B0 F3
            lda FKDEF              ; A5 60
            cmp L00CB              ; C5 CB
            bcc LAC50              ; 90 02
            lda L00CB              ; A5 CB
LAC50:      eor #$FF               ; 49 FF
            sec                    ; 38
            adc #$3F               ; 69 3F
            asl                    ; 0A
            cmp L00AB              ; C5 AB
            bcc LAC62              ; 90 08
            bit L00AA              ; 24 AA
            bvs LACB9              ; 70 5B
            ldy #$0F               ; A0 0F
            bne LAC8C              ; D0 2A
LAC62:      lda L00AB              ; A5 AB
            and #$07               ; 29 07
            tax                    ; AA
            ldy LBB1C,X            ; BC 1C BB
            ldx FKDEF              ; A6 60
            cpy #$07               ; C0 07
            bne LAC76              ; D0 06
            cpx #$05               ; E0 05
            bcs LAC84              ; B0 10
            ldy #$0D               ; A0 0D
LAC76:      cpy #$0C               ; C0 0C
            bne LAC84              ; D0 0A
            lda ICAX6Z             ; A5 2F
            bne LAC82              ; D0 04
            cpx #$03               ; E0 03
            bcs LAC84              ; B0 02
LAC82:      ldy #$08               ; A0 08
LAC84:      cpy #$0D               ; C0 0D
            bne LAC8C              ; D0 04
            lda #$05               ; A9 05
            sta L00B8              ; 85 B8
LAC8C:      lda OLD_ADR_HI           ; A5 5F
            cmp ICAX3Z             ; C5 2C
            bne LACBC              ; D0 2A
            sta L00B3              ; 85 B3
            lda FKDEF              ; A5 60
            lsr                    ; 4A
            bcc LACC2              ; 90 29
            lda #$3F               ; A9 3F
            ldx L00B8              ; A6 B8
            beq LACA1              ; F0 02
            lda #$37               ; A9 37
LACA1:      sbc L00B5              ; E5 B5
            sta L00B1              ; 85 B1
            lda L00AA              ; A5 AA
            and #$3F               ; 29 3F
            clc                    ; 18
            adc L00B5              ; 65 B5
            cmp L00B1              ; C5 B1
            bcc LACB2              ; 90 02
            lda L00B1              ; A5 B1
LACB2:      clc                    ; 18
            adc ROWCRS             ; 65 54
            bit L00AA              ; 24 AA
            bmi LAD29              ; 30 70
LACB9:      jmp LAD37              ; 4C 37 AD
LACBC:      bcs LACC0              ; B0 02
            lda ICAX3Z             ; A5 2C
LACC0:      sta L00B3              ; 85 B3
LACC2:      ldx #$0E               ; A2 0E
            bit ICAX4Z             ; 24 2D
            bpl LACC9              ; 10 01
            dex                    ; CA
LACC9:      cpx L00B3              ; E4 B3
            bcs LACD5              ; B0 08
            cpy #$07               ; C0 07
            beq LACD5              ; F0 04
            ldy #$01               ; A0 01
            bne LAD37              ; D0 62
LACD5:      ldx OLDCHR             ; A6 5D
            dex                    ; CA
            bne LACE0              ; D0 06
            inc L00B5              ; E6 B5
            inc L00B5              ; E6 B5
            bne LACEC              ; D0 0C
LACE0:      ldx #$0D               ; A2 0D
            bit ICAX4Z             ; 24 2D
            bpl LACE8              ; 10 02
            ldx #$0A               ; A2 0A
LACE8:      cpx L00B3              ; E4 B3
            bcs LACF6              ; B0 0A
LACEC:      cpy #$0D               ; C0 0D
            bne LACF6              ; D0 06
            lda #$00               ; A9 00
            sta L00B8              ; 85 B8
            ldy #$08               ; A0 08
LACF6:      lda L00B3              ; A5 B3
            asl                    ; 0A
            asl                    ; 0A
            beq LAD10              ; F0 14
            bit ICAX4Z             ; 24 2D
            bpl LAD10              ; 10 10
            eor #$FF               ; 49 FF
            adc #$41               ; 69 41
            ldx L00AA              ; A6 AA
            stx LTEMP+1            ; 86 37
            bpl LAD1D              ; 10 13
            eor #$FF               ; 49 FF
            adc #$80               ; 69 80
            bne LAD14              ; D0 04
LAD10:      bit L00AA              ; 24 AA
            bmi LAD19              ; 30 05
LAD14:      sec                    ; 38
            adc L00B5              ; 65 B5
            bne LAD37              ; D0 1E
LAD19:      eor #$FF               ; 49 FF
            adc #$81               ; 69 81
LAD1D:      cpy #$0F               ; C0 0F
            sbc #$08               ; E9 08
            sbc L00B5              ; E5 B5
            ldx L00B8              ; A6 B8
            beq LAD29              ; F0 02
            sbc #$08               ; E9 08
LAD29:      cpy #$0F               ; C0 0F
            beq LAD37              ; F0 0A
            pha                    ; 48
            ldx DRKMSK             ; A6 4E
            lda CRITIC,X           ; B5 42
            ora #$08               ; 09 08
            sta CRITIC,X           ; 95 42
            pla                    ; 68
LAD37:      ldx DRKMSK             ; A6 4E
            clc                    ; 18
            adc #$20               ; 69 20
            sta L00CA              ; 85 CA
            lda LMARGN             ; A5 52
            bit L052D              ; 2C 2D 05
            bpl LAD51              ; 10 0C
            cmp #$18               ; C9 18
            bcs LAD4B              ; B0 02
            lda #$18               ; A9 18
LAD4B:      cmp #$28               ; C9 28
            bcc LAD51              ; 90 02
            lda #$28               ; A9 28
LAD51:      clc                    ; 18
            adc L00CA              ; 65 CA
            sta L0516,X            ; 9D 16 05
            tya                    ; 98
            sta L0500,X            ; 9D 00 05
            sta L050B,X            ; 9D 0B 05
            cmp #$08               ; C9 08
            bne LAD88              ; D0 26
            lda HOLD1              ; A5 51
            cmp #$0B               ; C9 0B
            bcc LAD88              ; 90 20
            lda OLDCHR             ; A5 5D
            cmp #$0E               ; C9 0E
            bcs LAD88              ; B0 1A
            lda L00AC              ; A5 AC
            and #$70               ; 29 70
            bne LAD88              ; D0 14
            lda FKDEF              ; A5 60
            cmp #$0D               ; C9 0D
            bcc LAD88              ; 90 0E
            lda #$0A               ; A9 0A
            sta L0500,X            ; 9D 00 05
            sta L050B,X            ; 9D 0B 05
            lda #$00               ; A9 00
            sta L00C1              ; 85 C1
            stx HOLD1              ; 86 51
LAD88:      lda LBB60,Y            ; B9 60 BB
            clc                    ; 18
            adc #$04               ; 69 04
            sta BUFRLO             ; 85 32
            lda LBBA2,Y            ; B9 A2 BB
            sta L0521,X            ; 9D 21 05
            lda #$61               ; A9 61
            sec                    ; 38
            sbc BUFRLO             ; E5 32
            sta DOSINI,X           ; 95 0C
            lda ICAX6Z             ; A5 2F
            ora TANK_IND             ; 05 38
            beq LADA6              ; F0 03
LADA3:      jmp LAE94              ; 4C 94 AE
LADA6:      bit ICSTAZ             ; 24 23
            bpl LADCD              ; 10 23
            lda #$0B               ; A9 0B
            sta XMTDON             ; 85 3A
            ldx #$05               ; A2 05
            lda #$00               ; A9 00
            sta SOUNDR             ; 85 41
            sta FEOF               ; 85 3F
            lda #$02               ; A9 02
            sta FTYPE              ; 85 3E
            lda L00AA              ; A5 AA
            and #$7F               ; 29 7F
            cmp #$40               ; C9 40
            bcc LADC3              ; 90 01
            inx                    ; E8
LADC3:      stx TANK_IND             ; 86 38
            clc                    ; 18
            adc #$40               ; 69 40
            sta RECVDN             ; 85 39
            jmp LAE94              ; 4C 94 AE
LADCD:      ldx DRKMSK             ; A6 4E
            lda L0500,X            ; BD 00 05
            cmp #$08               ; C9 08
            bcc LADA3              ; 90 CD
            lda FKDEF              ; A5 60
            cmp #$07               ; C9 07
            bcc LADA3              ; 90 C7
            lda OLDCHR             ; A5 5D
            cmp #$05               ; C9 05
            bcc LADA3              ; 90 C1
            cmp #$0E               ; C9 0E
            bcs LADA3              ; B0 BD
            lda L00AC              ; A5 AC
            and #$C0               ; 29 C0
            bne LADA3              ; D0 B7
            ldx OLD_ADR_HI           ; A6 5F
            cpx ICAX3Z             ; E4 2C
            bcc LADF4              ; 90 02
            ldx ICAX3Z             ; A6 2C
LADF4:      cpx #$02               ; E0 02
            bcc LADA3              ; 90 AB
            cpx #$0E               ; E0 0E
            bcs LADA3              ; B0 A7
            lda L00AC              ; A5 AC
            lsr                    ; 4A
            lsr                    ; 4A
            lsr                    ; 4A
            ldy FKDEF              ; A4 60
            cpy #$0A               ; C0 0A
            bne LAE09              ; D0 02
            eor #$07               ; 49 07
LAE09:      and #$06               ; 29 06
            bne LAE17              ; D0 0A
            bit ICAX4Z             ; 24 2D
            bmi LAE17              ; 30 06
            cpx #$08               ; E0 08
            bcs LAE17              ; B0 02
            lda #$08               ; A9 08
LAE17:      tay                    ; A8
            lda LB7F4,Y            ; B9 F4 B7
            sta FTYPE              ; 85 3E
            lda LB7F5,Y            ; B9 F5 B7
            sta FEOF               ; 85 3F
            ldy #$05               ; A0 05
            bit ICAX4Z             ; 24 2D
            bpl LAE3E              ; 10 16
            lda LTEMP              ; A5 36
            bne LAE94              ; D0 68
            cpx #$0B               ; E0 0B
            bcs LAE94              ; B0 64
            cpx #$04               ; E0 04
            bcc LAE94              ; 90 60
            lda L00AC              ; A5 AC
            lsr                    ; 4A
            bcc LAE3A              ; 90 01
            iny                    ; C8
LAE3A:      lda #$4C               ; A9 4C
            bne LAE83              ; D0 45
LAE3E:      lda FKDEF              ; A5 60
            lsr                    ; 4A
            lda LBFE4,X            ; BD E4 BF
            bcc LAE6C              ; 90 26
            lda L00AC              ; A5 AC
            and #$1F               ; 29 1F
            cmp #$10               ; C9 10
            bcc LAE59              ; 90 0B
            adc #$57               ; 69 57
            ldx LTEMP              ; A6 36
            beq LAE56              ; F0 02
            bpl LAE5E              ; 10 08
LAE56:      iny                    ; C8
            bpl LAE63              ; 10 0A
LAE59:      ldx LTEMP              ; A6 36
            bpl LAE63              ; 10 06
            iny                    ; C8
LAE5E:      eor #$FF               ; 49 FF
            sec                    ; 38
            adc #$78               ; 69 78
LAE63:      clc                    ; 18
            adc LMARGN             ; 65 52
            clc                    ; 18
            adc #$20               ; 69 20
            jmp LAE86              ; 4C 86 AE
LAE6C:      cmp #$50               ; C9 50
            bcc LAE79              ; 90 09
            ldx LTEMP              ; A6 36
            beq LAE76              ; F0 02
            bpl LAE7E              ; 10 08
LAE76:      iny                    ; C8
            bpl LAE83              ; 10 0A
LAE79:      ldx LTEMP              ; A6 36
            bpl LAE83              ; 10 06
            iny                    ; C8
LAE7E:      eor #$FF               ; 49 FF
            sec                    ; 38
            adc #$98               ; 69 98
LAE83:      clc                    ; 18
            adc #$30               ; 69 30
LAE86:      sta RECVDN             ; 85 39
            sty TANK_IND             ; 84 38
            lda #$0C               ; A9 0C
            sta XMTDON             ; 85 3A
            lda #$FF               ; A9 FF
            sta TANKMISSLHIND               ; 85 50
            sta SOUNDR             ; 85 41
LAE94:      dec BUFRLO             ; C6 32
LAE96:      jmp LA701              ; 4C 01 A7
LAE99:      lda VCOUNT             ; AD 0B D4
            cmp #$50               ; C9 50
            bcs LAE99              ; B0 F9
            jsr LAFD0              ; 20 D0 AF
            lda XMTDON             ; A5 3A
            cmp #$BC               ; C9 BC
            bcc LAEAF              ; 90 06
            ldy #$00               ; A0 00
            sty TANK_IND             ; 84 38
            sty XMTDON             ; 84 3A
LAEAF:      sta L00A3              ; 85 A3
            lda #$0D               ; A9 0D
            sta L00A4              ; 85 A4
            lda TANK_IND             ; A5 38
            asl                    ; 0A
            tax                    ; AA
            lda LB4D1,X            ; BD D1 B4
            sta L00A1              ; 85 A1
            lda LB4D2,X            ; BD D2 B4
            sta L00A2              ; 85 A2
            ldy #$0A               ; A0 0A
            jsr DRAWTMISSL          ; 20 0F B0
            lda DSKFMS             ; A5 18
            lsr                    ; 4A
            lsr                    ; 4A
            lsr                    ; 4A
            and #$07               ; 29 07
            tax                    ; AA
            lda LBAC5,X            ; BD C5 BA
            sta COLPM0             ; 8D 12 D0
            ldx L00C2              ; A6 C2
            cpx #$1C               ; E0 1C
            bcc LAEFA              ; 90 1E
            lda L0AFE,X            ; BD FE 0A
            and #$FC               ; 29 FC
            sta L0AFE,X            ; 9D FE 0A
            lda L0AFF,X            ; BD FF 0A
            and #$FC               ; 29 FC
            sta L0AFF,X            ; 9D FF 0A
            lda L0B00,X            ; BD 00 0B
            and #$FC               ; 29 FC
            ldy L00C1              ; A4 C1
            beq LAEF7              ; F0 02
            ora #$03               ; 09 03
LAEF7:      sta L0B00,X            ; 9D 00 0B
LAEFA:      lda TANKMISSLVPOS               ; A5 40
            cmp #$BC               ; C9 BC
            bcc LAF09              ; 90 09
            ldy #$FF               ; A0 FF
            sty TANKMISSLHIND               ; 84 50
            iny                    ; C8
            sty CHKSNT             ; 84 3B
            sty TANKMISSLVPOS               ; 84 40
LAF09:      sta L00A3              ; 85 A3
            lda #$0C               ; A9 0C
            sta L00A4              ; 85 A4
            lda CHKSNT             ; A5 3B
            asl                    ; 0A
            tax                    ; AA
            lda LBAB7,X            ; BD B7 BA
            sta L00A1              ; 85 A1
            lda LBAB8,X            ; BD B8 BA
            sta L00A2              ; 85 A2
            ldy #$0F               ; A0 0F
            jsr DRAWTMISSL              ; 20 0F B0
            ldy #$0F               ; A0 0D
            lda CRAFT_IND             ; A5 5E
            asl                    ; 0A
            tax                    ; AA
            lda LBACD,X            ; BD CD BA
            sta L00A1              ; 85 A1
            lda LBACE,X            ; BD CE BA
            sta L00A2              ; 85 A2
	    ; CRAFT
LAF32:      lda (L00A1),Y          ; B1 A1
            sta L0EAA,Y            ; 99 AA 0E
            dey                    ; 88
            bpl LAF32              ; 10 F8
            lda VCOUNT             ; AD 0B D4
            cmp #$07               ; C9 07
            bcs LAF52              ; B0 11
            lda ICAX1Z             ; A5 2A
            bne LAF48              ; D0 03
            jsr LAF5B              ; 20 5B AF
LAF48:      jsr LB05C              ; 20 5C B0
            lda DELTAC             ; A5 77
            bne LAF55              ; D0 06
            jsr LB07C              ; 20 7C B0
LAF52:      jmp LA197              ; 4C 97 A1
LAF55:      jsr LB068              ; 20 68 B0
            jmp LA197              ; 4C 97 A1
LAF5B:      ldx #$00               ; A2 00
            ldy RAMTOP             ; A4 6A
            beq LAF75              ; F0 14
            lda COUNTR             ; A5 7E
            beq LAF6C              ; F0 07
            and #$08               ; 29 08
            beq LAF6C              ; F0 03
            dey                    ; 88
            beq LAF75              ; F0 09
LAF6C:      lda #$9C               ; A9 9C
LAF6E:      sta L1033,X            ; 9D 33 10
            inx                    ; E8
            dey                    ; 88
            bne LAF6E              ; D0 F9
LAF75:      lda #$00               ; A9 00
LAF77:      sta L1033,X            ; 9D 33 10
            inx                    ; E8
            cpx #$09               ; E0 09
            bcc LAF77              ; 90 F8
            rts                    ; 60
	    ; DISTORTS BANKS DRAWS OBJECTS
LAF80:      lda BOOT               ; A5 09
            ror                    ; 6A
            bcs LAF8E              ; B0 09
            jsr LB06E              ; 20 6E B0
            lda #$DB               ; A9 DB
            ldx #$D0               ; A2 D0
            bne LAF95              ; D0 07
LAF8E:      jsr LB068              ; 20 68 B0
            lda #$4F               ; A9 4F
            ldx #$50               ; A2 50
LAF95:      sta L100B              ; 8D 0B 10
            stx L1012              ; 8E 12 10
            lda BOOT               ; A5 09
            lsr                    ; 4A
            tax                    ; AA
            lda LB494,X            ; BD 94 B4
            sta MLTTMP             ; 85 66
            sta ROWAC1            ; 85 71
            lda LB498,X            ; BD 98 B4
            sta MLTTMP+1           ; 85 67
            sta COLAC              ; 85 72
            lda LB49C,X            ; BD 9C B4
            sta SAVADR             ; 85 68
            sta COLAC+1            ; 85 73
            lda LB4A0,X            ; BD A0 B4
            sta SAVADR+1           ; 85 69
            sta ENDPT              ; 85 74
            lda LB4A4,X            ; BD A4 B4
            sta FKDEF              ; 85 60
            sta BUFCNT             ; 85 6B
            lda LB4A8,X            ; BD A8 B4
            sta PALNTS             ; 85 62
            sta BUFSTR+1           ; 85 6D
            lda #$00               ; A9 00
            sta FKDEF+1            ; 85 61
            sta BUFSTR             ; 85 6C
            rts                    ; 60
LAFD0:      lda ICSTAZ             ; A5 23
            and #$04               ; 29 04
            eor #$D6               ; 49 D6
            ldx DRKMSK             ; A6 4E
            cpx #$0B               ; E0 0B
            bcs LAFE8              ; B0 0C
            ldy CRITIC,X           ; B4 42
            bpl LAFE8              ; 10 08
            ldy DOSINI,X           ; B4 0C
            cpy #$5C               ; C0 5C
            bcs LAFE8              ; B0 02
            eor #$04               ; 49 04
LAFE8:      sta COLPF0             ; 8D 16 D0
            rts                    ; 60
LAFEC:      lda #$AA               ; A9 AA
            bne LAFFA              ; D0 0A
LAFF0:      lda #$FF               ; A9 FF
            bne LAFFA              ; D0 06
LAFF4:      lda COLRSH             ; A5 4F
            bne LAFEC              ; D0 F4
            lda #$55               ; A9 55
LAFFA:      sty L00B6              ; 84 B6
            dey                    ; 88
            bmi LB009              ; 30 0A
	    ; BACKGROUND
LAFFF:      sta (L00A3),Y          ; 91 A3
            dey                    ; 88
            bpl LAFFF              ; 10 FB
            lda L00B6              ; A5 B6
            jsr LB04B              ; 20 4B B0
LB009:      txa                    ; 8A
            and #$03               ; 29 03
            asl                    ; 0A
            asl                    ; 0A
            rts                    ; 60
DRAWTMISSL:  tya                    ; 98
            bmi LB019              ; 30 07
	    ; TANK
LB012:      lda (L00A1),Y          ; B1 A1
            sta (L00A3),Y          ; 91 A3
            dey                    ; 88
            bpl LB012              ; 10 F9
LB019:      rts                    ; 60
LB01A:      ldy CURRMOUNTWIDTH              ; A4 BC
            dey                    ; 88
	    ; MOUNTAINS
LB01D:      lda (L00BA),Y          ; B1 BA
            sta (L00A3),Y          ; 91 A3
            dey                    ; 88
            bpl LB01D              ; 10 F9
            lda L00BA              ; A5 BA
            clc                    ; 18
            adc CURRMOUNTWIDTH              ; 65 BC
            sta L00BA              ; 85 BA
            bcc LB02F              ; 90 02
            inc L00BB              ; E6 BB
LB02F:      lda CURRMOUNTWIDTH              ; A5 BC
            jmp LB04B              ; 4C 4B B0
LB034:      ldy COLRSH             ; A4 4F
            beq LB03B              ; F0 03
            clc                    ; 18
            adc #$10               ; 69 10
LB03B:      sta L00A1              ; 85 A1
            ldy #$01               ; A0 01
	    ; BANKS
            lda (L00A1),Y          ; B1 A1
            sta (L00A3),Y          ; 91 A3
            dey                    ; 88
            lda (L00A1),Y          ; B1 A1
            sta (L00A3),Y          ; 91 A3
            dey                    ; 88
            lda #$02               ; A9 02
LB04B:      pha                    ; 48
            clc                    ; 18
            adc L00A3              ; 65 A3
            sta L00A3              ; 85 A3
            bcc LB055              ; 90 02
            inc L00A4              ; E6 A4
LB055:      pla                    ; 68
            clc                    ; 18
            adc L00B4              ; 65 B4
            sta L00B4              ; 85 B4
            rts                    ; 60
LB05C:      lda #$90               ; A9 90
            sta L00B1              ; 85 B1
            ldx #$61               ; A2 61
            ldy #$23               ; A0 23
LB064:      lda #$02               ; A9 02
            bne LB086              ; D0 1E
LB068:      lda #$50               ; A9 50
            ldy #$0C               ; A0 0C
            bne LB080              ; D0 12
LB06E:      lda BOOT               ; A5 09
            and #$0E               ; 29 0E
            asl                    ; 0A
            adc #$80               ; 69 80
            tax                    ; AA
            lda #$D0               ; A9 D0
            ldy #$0C               ; A0 0C
            bne LB082              ; D0 06
LB07C:      lda #$10               ; A9 10
            ldy #$02               ; A0 02
LB080:      ldx #$63               ; A2 63
LB082:      sta L00B1              ; 85 B1
            lda #$03               ; A9 03
LB086:      bit ICBLHZ             ; 24 29
            bmi LB0C6              ; 30 3C
            sta L00B2              ; 85 B2
LB08C:      lda $00,X              ; B5 00
            lsr                    ; 4A
            lsr                    ; 4A
            lsr                    ; 4A
            lsr                    ; 4A
            bne LB0AF              ; D0 1B
            sta L1000,Y            ; 99 00 10
            iny                    ; C8
            lda $00,X              ; B5 00
            and #$0F               ; 29 0F
            bne LB0BA              ; D0 1C
            sta L1000,Y            ; 99 00 10
            iny                    ; C8
            inx                    ; E8
            dec L00B2              ; C6 B2
            bne LB08C              ; D0 E5
            beq LB0C6              ; F0 1D
LB0A9:      lda $00,X              ; B5 00
            lsr                    ; 4A
            lsr                    ; 4A
            lsr                    ; 4A
            lsr                    ; 4A
LB0AF:      clc                    ; 18
            adc L00B1              ; 65 B1
            sta L1000,Y            ; 99 00 10
            iny                    ; C8
            lda $00,X              ; B5 00
            and #$0F               ; 29 0F
LB0BA:      clc                    ; 18
            adc L00B1              ; 65 B1
            sta L1000,Y            ; 99 00 10
            iny                    ; C8
            inx                    ; E8
            dec L00B2              ; C6 B2
            bne LB0A9              ; D0 E3
LB0C6:      rts                    ; 60
LB0C7:      ldy #$03               ; A0 03
            ldx L00A6              ; A6 A6
LB0CB:      lda LB0E9,Y            ; B9 E9 B0
            sta L3F04,X            ; 9D 04 3F
            inx                    ; E8
            dey                    ; 88
            bpl LB0CB              ; 10 F6
            inc L00A6              ; E6 A6
            rts                    ; 60
LB0D8:      ldy #$03               ; A0 03
            ldx L00A5              ; A6 A5
LB0DC:      lda LB0ED,Y            ; B9 ED B0
            sta L3F04,X            ; 9D 04 3F
            inx                    ; E8
            dey                    ; 88
            bpl LB0DC              ; 10 F6
            inc L00A5              ; E6 A5
            rts                    ; 60
LB0E9:      .by $30,$00,$4E,$0E
LB0ED:      .by $20,$00,$4E,$0E
	   ; DRAWS EVERYTNING?
LB0F1:      lda LBAE1,X            ; BD E1 BA
            sta ATRACT,X           ; 95 4D
            dex                    ; CA
            bpl LB0F1              ; 10 F8
            stx ICCOMT             ; 86 17
            ldx #$0B               ; A2 0B
            lda #$00               ; A9 00
            sta L00A1              ; 85 A1
            sta L00C7              ; 85 C7
LB103:      ldy #$BC               ; A0 BC
            stx L00A2              ; 86 A2
	    ;???
LB107:      sta (L00A1),Y          ; 91 A1
            dey                    ; 88
            bne LB107              ; D0 FB
            inx                    ; E8
            cpx #$10               ; E0 10
            bcc LB103              ; 90 F2
            lda #$00               ; A9 00
            ldx #$20               ; A2 20
LB115:      stx L00A2              ; 86 A2
LB117:      sta (L00A1),Y          ; 91 A1
            iny                    ; C8
            bne LB117              ; D0 FB
            inx                    ; E8
            cpx #$3F               ; E0 3F
            bcc LB115              ; 90 F4
            inc L00C7              ; E6 C7
            lda #$00               ; A9 00
            ldx #$21               ; A2 21
LB127:      sta ICAX2Z,X           ; 95 2B
            dex                    ; CA
            bpl LB127              ; 10 FB
            inx                    ; E8
LB12D:      sta L0500,X            ; 9D 00 05
            inx                    ; E8
            bne LB12D              ; D0 FA
            ldy #$06               ; A0 06
            lda L00BF              ; A5 BF
            bne LB13B              ; D0 02
            ldy #$12               ; A0 12
LB13B:      ldx #$06               ; A2 06
LB13D:      lda #$FF               ; A9 FF
            sta L0EDB,Y            ; 99 DB 0E
            lda #$FC               ; A9 FC
            sta L0FDB,Y            ; 99 DB 0F
            dey                    ; 88
            dex                    ; CA
            bpl LB13D              ; 10 F2
            ldx #$09               ; A2 09
            ldy #$09               ; A0 09
            lda L00BF              ; A5 BF
            bne LB155              ; D0 02
            ldy #$10               ; A0 10
LB155:      lda #$0C               ; A9 0C
LB157:      sta L0BCC,Y            ; 99 CC 0B
            dey                    ; 88
            dex                    ; CA
            bpl LB157              ; 10 F9
            lda #$17               ; A9 17
            sta BUFRLO             ; 85 32
            lda #$0E               ; A9 0E
            sta L0515              ; 8D 15 05
            lda #$4A               ; A9 4A
            sta BUFADR+1           ; 85 16
            lda FKDEF              ; A5 60
            lsr                    ; 4A
            lda #$D6               ; A9 D6
            bcs LB174              ; B0 02
            lda #$D2               ; A9 D2
LB174:      sta DOSVEC+1           ; 85 0B
            and #$84               ; 29 84
            sta DSTAT              ; 85 4C
            sta ICSTAZ             ; 85 23
            lda #$0A               ; A9 0A
            sta ATRACT             ; 85 4D
            sta DRKMSK             ; 85 4E
            rts                    ; 60
LB183:      lda L00AB              ; A5 AB
            asl                    ; 0A
            asl                    ; 0A
            asl                    ; 0A
            asl                    ; 0A
            asl                    ; 0A
            eor L00AB              ; 45 AB
            asl                    ; 0A
            rol L00AA              ; 26 AA
            rol L00AC              ; 26 AC
            rol L00AB              ; 26 AB
            rts                    ; 60
	    ; ???
LB194:      ldx FKDEF              ; A6 60
            cpx #$50               ; E0 50
            bcc LB19C              ; 90 02
            ldx #$4E               ; A2 4E
LB19C:      lda MLTTMP             ; A5 66
            sta L00AD              ; 85 AD
            lda MLTTMP+1           ; A5 67
            sta L00AE              ; 85 AE
            lda SAVADR             ; A5 68
            sta L00AF              ; 85 AF
            lda SAVADR+1           ; A5 69
            sta L00B0              ; 85 B0
            lda L00AA              ; A5 AA
            sta MLTTMP             ; 85 66
            lda L00AB              ; A5 AB
            sta MLTTMP+1           ; 85 67
            lda L00AC              ; A5 AC
            sta SAVADR             ; 85 68
            lda LMARGN             ; A5 52
            sta SAVADR+1           ; 85 69
            inx                    ; E8
            stx FKDEF              ; 86 60
            rts                    ; 60
LB1C0:      sty LOWFUELPITCH             ; 84 7B
            sta KEYDEF+1           ; 85 7A
            lda DSTAT              ; A5 4C
            eor ICSTAZ             ; 45 23
            and #$04               ; 29 04
            beq LB1F8              ; F0 2C
            lda ICAX5Z             ; A5 2E
            beq LB1D9              ; F0 09
            bit ICSTAZ             ; 24 23
            bpl LB1F8              ; 10 24
            jsr LB194              ; 20 94 B1
            bne LB1F8              ; D0 1F
LB1D9:      bit ICSTAZ             ; 24 23
            bmi LB1F8              ; 30 1B
            ldx FKDEF              ; A6 60
            dex                    ; CA
            cpx #$4E               ; E0 4E
            bne LB1E6              ; D0 02
            ldx #$50               ; A2 50
LB1E6:      stx FKDEF              ; 86 60
            lda L00AD              ; A5 AD
            sta MLTTMP             ; 85 66
            lda L00AE              ; A5 AE
            sta MLTTMP+1           ; 85 67
            lda L00AF              ; A5 AF
            sta SAVADR             ; 85 68
            lda L00B0              ; A5 B0
            sta SAVADR+1           ; 85 69
	    ; BEGIN OF CRAFT EXPLOSION
LB1F8:      lda #$06               ; A9 06
            sta CRAFT_IND             ; 85 5E
            lda #$FE               ; A9 FE
            ldx #$00               ; A2 00
LB200:      sta INGAME             ; 85 76
            stx ICAX1Z             ; 86 2A
            jsr CLR_MISSL              ; 20 21 B2
            lda #$0B               ; A9 0B
            sta HOLD1              ; 85 51
            ldx L00C2              ; A6 C2
            lda L0B00,X            ; BD 00 0B
            and #$FC               ; 29 FC
            sta L0B00,X            ; 9D 00 0B
            lda #$01               ; A9 01
            sta MISSILEVPOS           ; 85 56
            rts                    ; 60
LB21A:      lda #$FF               ; A9 FF
            sta DSKFMS             ; 85 18
            tax                    ; AA
            bne LB200              ; D0 DF
	    ; LOOKS LIKE CRAFT MISSILE MOVE AND ERASE
CLR_MISSL:      lda #$00               ; A9 00
DRAW_MISSL:      ldx MISSILEVPOS           ; A6 56
            dex                    ; CA
            beq LB246              ; F0 1E
            cpx #$1B               ; E0 1B
            bcs LB22E              ; B0 02
            ldx #$1B               ; A2 1B
LB22E:      sta L0B01,X            ; 9D 01 0B
            sta L0B02,X            ; 9D 02 0B
            sta L0B03,X            ; 9D 03 0B
            sta L0B04,X            ; 9D 04 0B
            sta L0B05,X            ; 9D 05 0B
            sta L0B06,X            ; 9D 06 0B
            ;sta L0B07,X            ; 9D 07 0B
            ;sta L0B08,X            ; 9D 08 0B
	    nop
	    nop
	    nop
	    nop
	    nop
	    nop
LB246:      rts                    ; 60
LB247:      lda BOOT               ; A5 09
            and #$01               ; 29 01
            beq LB260              ; F0 13
            eor DELTAC             ; 45 77
            sta DELTAC             ; 85 77
            ldx #$0A               ; A2 0A
LB253:      lda FKDEF,X            ; B5 60
            pha                    ; 48
            lda BUFCNT,X           ; B5 6B
            sta FKDEF,X            ; 95 60
            pla                    ; 68
            sta BUFCNT,X           ; 95 6B
            dex                    ; CA
            bpl LB253              ; 10 F3
LB260:      rts                    ; 60
LB261:      sta L00A1              ; 85 A1
            lda #$00               ; A9 00
            sta L00A2              ; 85 A2
            sta L00A4              ; 85 A4
            lda BOOT               ; A5 09
            and #$0E               ; 29 0E
            asl                    ; 0A
            adc #$80               ; 69 80
            sta L00A3              ; 85 A3
            ldy #$00               ; A0 00
LB274:      lda (L00A1),Y          ; B1 A1
            cmp (L00A3),Y          ; D1 A3
            bcc LB297              ; 90 1D
            bne LB281              ; D0 05
            iny                    ; C8
            cpy #$03               ; C0 03
            bcc LB274              ; 90 F3
LB281:      ldy #$02               ; A0 02
	; ???
LB283:      lda (L00A1),Y          ; B1 A1
            sta (L00A3),Y          ; 91 A3
            dey                    ; 88
            bpl LB283              ; 10 F9
            ldy #$0F               ; A0 0F
LB28C:      sty L00A0              ; 84 A0
            jsr LB298              ; 20 98 B2
            sta L0090,Y            ; 99 90 00
            dey                    ; 88
            bpl LB28C              ; 10 F5
LB297:      rts                    ; 60
	; ???
LB298:      lda #$00               ; A9 00
            ldx #$0E               ; A2 0E
            clc                    ; 18
LB29D:      adc LOMEM,X            ; 75 80
            eor L00A0              ; 45 A0
            dex                    ; CA
            bpl LB29D              ; 10 F9
            rts                    ; 60
VBLK:       cld                    ; D8
            lda L00C6              ; A5 C6
            beq LB2BA              ; F0 10
            dec L00C6              ; C6 C6
            lda #$40               ; A9 40
            sta AUDF1              ; 8D 00 D2
            lda #$AF               ; A9 AF
            sta AUDC1              ; 8D 01 D2
            ldx #$00               ; A2 00
            beq LB2C5              ; F0 0B
LB2BA:      lda ICBALZ             ; A5 24
            cmp #$02               ; C9 02
            bcc LB2CE              ; 90 0E
            ldx #$00               ; A2 00
            stx AUDC1              ; 8E 01 D2
LB2C5:      stx AUDC2              ; 8E 03 D2
            stx AUDC3              ; 8E 05 D2
            jmp LB3D8              ; 4C D8 B3
LB2CE:      ldy #$39               ; A0 39
            lda LOWFUELPITCH             ; A5 7B
            ldx KEYDEF+1           ; A6 7A
            beq LB2F9              ; F0 23
            dex                    ; CA
            beq LB2E1              ; F0 08
            ldy #$1F               ; A0 1F
            cpx #$02               ; E0 02
            bcs LB2E6              ; B0 07
            ldy #$11               ; A0 11
LB2E1:      sec                    ; 38
            ror                    ; 6A
            tax                    ; AA
            bne LB2EE              ; D0 08
LB2E6:      beq LB2EA              ; F0 02
            ldy #$3F               ; A0 3F
LB2EA:      clc                    ; 18
            adc #$A0               ; 69 A0
            tax                    ; AA
LB2EE:      dec LOWFUELPITCH             ; C6 7B
            bne LB34C              ; D0 5A
            lda #$00               ; A9 00
            sta KEYDEF+1           ; 85 7A
            jmp LB34C              ; 4C 4C B3
LB2F9:      lda INGAME             ; A5 76
            bne LB34F              ; D0 52
            lda FUEL             ; A5 5B
            cmp #$40               ; C9 40
            bcs LB32C              ; B0 29
            ldy LOWFUELPITCH             ; A4 7B
            bne LB309              ; D0 02
            ldy #$3F               ; A0 3F
LB309:      dey                    ; 88
            sty LOWFUELPITCH             ; 84 7B
	    ; alert low fuel
            ldx FUEL+1           ; A6 5C
            stx RAMLO              ; 86 04
            cmp #$04               ; C9 04
            bcs LB321              ; B0 0D
            rol RAMLO              ; 26 04
            rol                    ; 2A
            rol RAMLO              ; 26 04
            rol                    ; 2A
            eor #$FF               ; 49 FF
            adc #$20               ; 69 20
            asl                    ; 0A
            bne LB326              ; D0 05
LB321:      cpy #$1C               ; C0 1C
            bcc LB32C              ; 90 07
            tya                    ; 98
LB326:      asl                    ; 0A
            tay                    ; A8
            ldx #$AF               ; A2 AF
            bne LB34C              ; D0 20
LB32C:      lda CRAFT_SPEED           ; A5 59
            lsr                    ; 4A
            lsr                    ; 4A
            lsr                    ; 4A
            lsr                    ; 4A
            eor #$FF               ; 49 FF
            sec                    ; 38
            adc #$1F               ; 69 1F
            tay                    ; A8
            lda L052C              ; AD 2C 05
            cmp #$1B               ; C9 1B
            bcc LB343              ; 90 04
            dec L052C              ; CE 2C 05
            tay                    ; A8
LB343:      ;lda STICK_BUF           ; A5 19
            ;and #$03               ; 29 03
            ;tax                    ; AA
            ;lda LB4AC,X            ; BD AC B4
            ;tax                    ; AA
	    lda #1
	    sta $82
	    jmp LB34F+3
	    nop
	    nop
	    ; ENGINE SOUND
	    
LB34C:      ;sty AUDF1              ; 8C 00 D2
	    jsr MAKENOISEF
LB34F:      ;stx AUDC1              ; 8E 01 D2
	    jsr MAKENOISEC
	;	nop
	;	nop
	;	nop
            ldx EXPL_CNT             ; A6 7C
            beq LB367              ; F0 11
            dec EXPL_CNT             ; C6 7C
            txa                    ; 8A
            lsr                    ; 4A
            clc                    ; 18
            adc #$04               ; 69 04
            and #$0F               ; 29 0F
            adc #$80               ; 69 80
            tax                    ; AA
            lda RANDOM             ; AD 0A D2
            ora #$18               ; 09 18
LB367:      ldy COUNTR+1           ; A4 7F
            beq LB37E              ; F0 13
            dec COUNTR+1           ; C6 7F
            bit ICBLHZ             ; 24 29
            bmi LB37E              ; 30 0D
            tya                    ; 98
            clc                    ; 18
            adc #$46               ; 69 46
            tax                    ; AA
            eor #$0E               ; 49 0E
            adc #$04               ; 69 04
            and #$0F               ; 29 0F
            asl                    ; 0A
            asl                    ; 0A
	    ;???
LB37E:      sta AUDF2              ; 8D 02 D2
            stx AUDC2              ; 8E 03 D2
            ldx #$00               ; A2 00
            lda CRMISSL_CNT             ; A5 7D
            beq LB399              ; F0 0F
            dec CRMISSL_CNT             ; C6 7D
            eor #$FF               ; 49 FF
            sec                    ; 38
            adc #$1C               ; 69 1C
            asl                    ; 0A
            sta RAMLO              ; 85 04
            asl                    ; 0A
            adc RAMLO              ; 65 04
            ldx #$A8               ; A2 A8
LB399:      ldy COUNTR             ; A4 7E
            beq LB3B0              ; F0 13
            dey                    ; 88
            sty COUNTR             ; 84 7E
            tya                    ; 98
            and #$0F               ; 29 0F
            clc                    ; 18
            adc #$A0               ; 69 A0
            tax                    ; AA
            tya                    ; 98
            lsr                    ; 4A
            lsr                    ; 4A
            lsr                    ; 4A
            lsr                    ; 4A
            tay                    ; A8
            lda LB4E1,Y            ; B9 E1 B4
LB3B0:      sta AUDF3              ; 8D 04 D2
            stx AUDC3              ; 8E 05 D2
            ldx #$00               ; A2 00
            bit ICBLHZ             ; 24 29
            bmi LB3D8              ; 30 1C
            lda TANKMISSLHIND               ; A5 50
            bmi LB3D8              ; 30 18
            beq LB3D8              ; F0 16
            cmp #$11               ; C9 11
            bcs LB3CE              ; B0 08
            tax                    ; AA
            lda LB4C0,X            ; BD C0 B4
            ldx #$AC               ; A2 AC
            bne LB3D5              ; D0 07
LB3CE:      ldx #$8C               ; A2 8C
            lda RANDOM             ; AD 0A D2
            ora #$20               ; 09 20
LB3D5:      sta AUDF4              ; 8D 06 D2
LB3D8:      stx AUDC4              ; 8E 07 D2
            inc DSKFMS             ; E6 18
            bne LB3F2              ; D0 13
            inc ICBLHZ             ; E6 29
            lda ICBLHZ             ; A5 29
            and #$C7               ; 29 C7
            sta ICBLHZ             ; 85 29
            and #$07               ; 29 07
            bne LB3F2              ; D0 07
            inc DELTAC+1           ; E6 78
            bne LB3F2              ; D0 03
            sec                    ; 38
            ror DELTAC+1           ; 66 78
LB3F2:      ldy #$3F               ; A0 3F
            ldx #$C0               ; A2 C0
            lda DELTAC+1           ; A5 78
            rol                    ; 2A
            lda #$03               ; A9 03
            bcc LB402              ; 90 05
            lda #$00               ; A9 00
            tay                    ; A8
            ldx #$40               ; A2 40
LB402:      sta GRACTL             ; 8D 1D D0
            stx NMIEN              ; 8E 0E D4
            sty DMACTL             ; 8C 00 D4
            ldx #$01               ; A2 01
            stx PRIOR              ; 8E 1B D0
            dex                    ; CA
            stx HPOSP3             ; 8E 03 D0
            ldx #$84               ; A2 84
            lda ICBALZ             ; A5 24
            cmp #$02               ; C9 02
            bcs LB427              ; B0 0B
            lda CHKSUM             ; A5 31
            beq LB427              ; F0 07
            dec CHKSUM             ; C6 31
            lsr                    ; 4A
            bcc LB427              ; 90 02
            ldx #$42               ; A2 42
LB427:      stx COLPF2             ; 8E 18 D0
            lda #$20               ; A9 20
            sta COLPF1             ; 8D 17 D0
            jsr LAFD0              ; 20 D0 AF
            lda L00C7              ; A5 C7
            bne LB441              ; D0 0B
            lda #$00               ; A9 00
            sta COLPF0             ; 8D 16 D0
            sta COLPF1             ; 8D 17 D0
            sta COLPF2             ; 8D 18 D0
LB441:      lda #$00               ; A9 00
            sta DLISTL             ; 8D 02 D4
            lda #$3F               ; A9 3F
            sta DLISTH             ; 8D 03 D4
            lda #$44               ; A9 44
            ldx #$E7               ; A2 E7
            ldy ICAX1Z             ; A4 2A
            beq LB478              ; F0 25
            ldy ICPTHZ             ; A4 27
            dey                    ; 88
            tya                    ; 98
            ldx L3FB3              ; AE B3 3F
            ldy ICPTLZ             ; A4 26
            dey                    ; 88
            bpl LB478              ; 10 19
            inx                    ; E8
            cpx #$D7               ; E0 D7
            bcc LB466              ; 90 02
            ldx #$4B               ; A2 4B
LB466:      cpx #$9B               ; E0 9B
            bcs LB474              ; B0 0A
            cpx #$7E               ; E0 7E
            bcc LB474              ; 90 06
            bne LB476              ; D0 06
            lda #$EC               ; A9 EC
            bne LB476              ; D0 02
LB474:      lda #$00               ; A9 00
LB476:      ldy #$07               ; A0 07
LB478:      sta ICPTHZ             ; 85 27
            stx L3FB3              ; 8E B3 3F
            sty ICPTLZ             ; 84 26
            sty HSCROL             ; 8C 04 D4
            jmp ANIMATEK             ; 4C 62 E4
IRQ:        pha                    ; 48
            lda #$00               ; A9 00
            sta IRQEN              ; 8D 0E D2
            pla                    ; 68
            rti                    ; 40
LB48D:      .by $84,$D6,$D6,$1A,$26,$26,$44
LB494:      .by $E3,$20,$80,$B4
LB498:      .by $D4,$83,$C1,$6D
LB49C:      .by $F7,$B5,$7F,$C0
LB4A0:      .by $20,$21,$20,$21
LB4A4:      .by $01,$05,$14,$32
LB4A8:      .by $01,$05,$20,$50
		; SOUND PITCH AUDIO1 :none:down:up:neutral
LB4AC:      .by $00,$83,$86,$84
		; TANK MISSILE VERTICAL DELTAS 
LB4B0:      .by $00,$00,$00,$00,$01,$00,$01,$00
	    .by $01,$00,$01,$00,$01,$01,$01,$01
	    ; TANK ANIM SOUND
LB4C0:      .by $0C,$0E,$11,$15,$19,$1E,$24,$2B
            .by $34,$3E,$4A,$59,$6B,$80,$9A,$B9
            .by $DE
	    ; TANK ANIM VECTORS
LB4D1:      .wo $B900,$B94C,$B91A,$B94C
            .wo $B9E9,$B9F4,$B9FF,$BA0A
LB4E1:      .by $30,$40,$50,$60
	; BRIDGE COLORS UPSIDE DOWN BACKGROUND
LB4E5:      .by $04,$04,$04,$04,$08,$08,$08,$08
            .by $08,$08,$1C,$1C,$06,$06,$06,$06
            .by $06,$04,$04,$04,$FF,$FF,$FF,$FF
            .by $FF,$FF,$FF
DLINT        cld                    ; D8
            pha                    ; 48
            txa                    ; 8A
            pha                    ; 48
            tya                    ; 98
            pha                    ; 48
            lda VCOUNT             ; AD 0B D4
            cmp #$3F               ; C9 3F
            bcc LB510              ; 90 03
            jmp LB72A              ; 4C 2A B7
LB510:      lda #$FF               ; A9 FF
            sta DSKUTL             ; 85 1A
            sta DSKUTL+1           ; 85 1B
            sta ABUFPT             ; 85 1C
            sta ABUFPT+1           ; 85 1D
            sta ABUFPT+2           ; 85 1E
            sta ICHIDZ             ; 85 20
            sta WSYNC              ; 8D 0A D4
            sta ICDNOZ             ; 85 21
            sta ICCOMZ             ; 85 22
            sta ABUFPT+3           ; 85 1F
            lda FUEL             ; A5 5B
            lsr                    ; 4A
            lsr                    ; 4A
            lsr                    ; 4A
            clc                    ; 18
            adc #$5C               ; 69 5C
            sta HPOSM1             ; 8D 05 D0
	    ; HORIZONTAL POS
            lda DINDEX             ; A5 57
            sta HPOSP2             ; 8D 02 D0
            clc                    ; 18
	    ; MISSILE OFFSET
            adc #$03               ; 69 04
            sta HPOSM2             ; 8D 06 D0
            lda #$00               ; A9 00
            sta COLPM1             ; 8D 13 D0
            lda #$8E               ; A9 8E
            ldx DELTAC             ; A6 77
            bne LB54A              ; D0 02
            lda #$1E               ; A9 1E
LB54A:      sta COLPM2             ; 8D 14 D0
            lda RECVDN             ; A5 39
            sta HPOSP1             ; 8D 01 D0
            lda L00C1              ; A5 C1
            sta HPOSM0             ; 8D 04 D0
            lda NOCKSM             ; A5 3C
            sta HPOSP0             ; 8D 00 D0
            ldy ATRACT             ; A4 4D
            ldx #$5D               ; A2 5D
            bne LB565              ; D0 03
LB562:      ldy TRAMSZ             ; A4 06
            iny                    ; C8
LB565:      sty TRAMSZ             ; 84 06
LB567:      sta WSYNC              ; 8D 0A D4
            txa                    ; 8A
            cmp DOSINI,Y           ; D9 0C 00
            bcs LB575              ; B0 05
            inx                    ; E8
            bne LB567              ; D0 F4
            beq LB5E3              ; F0 6E
LB575:      stx RAMLO              ; 86 04
            inx                    ; E8
            beq LB5E3              ; F0 69
            lda L0516,Y            ; B9 16 05
            sta HPOSP3             ; 8D 03 D0
            lda #$00               ; A9 00
            sta L0EBC,X            ; 9D BC 0E
            sta L0EBD,X            ; 9D BD 0E
            lda CRITIC,Y           ; B9 42 00
            sta CMCMD              ; 85 07
            sta WSYNC              ; 8D 0A D4
            and #$08               ; 29 08
            beq LB596              ; F0 02
            lda #$10               ; A9 10
LB596:      clc                    ; 18
            adc L0500,Y            ; 79 00 05
            tay                    ; A8
            lda LBB40,Y            ; B9 40 BB
            sta $00                ; 85 00
            inx                    ; E8
            beq LB5E3              ; F0 40
            ldy TRAMSZ             ; A4 06
            lda L0521,Y            ; B9 21 05
            sta SIZEP3             ; 8D 0B D0
            lda DOSINI,Y           ; B9 0C 00
            sta RAMLO+1            ; 85 05
            sta WSYNC              ; 8D 0A D4
            lda L050B,Y            ; B9 0B 05
            tay                    ; A8
            lda LBB30,Y            ; B9 30 BB
            sta SPRCOLPTR             ; 85 02
            lda RAMLO+1            ; A5 05
            clc                    ; 18
            adc LBB60,Y            ; 79 60 BB
            sec                    ; 38
            sbc RAMLO              ; E5 04
            inx                    ; E8
            beq LB5E3              ; F0 1B
            tay                    ; A8
            bmi LB562              ; 30 97
	    ; SPRITES
LB5CB:      lda ($00),Y            ; B1 00
            sta L0EBC,X            ; 9D BC 0E
            sta WSYNC              ; 8D 0A D4
            bit CMCMD              ; 24 07
            bpl LB5DD              ; 10 06
            lda LB4E5,Y            ; B9 E5 B4
            sta COLPF0             ; 8D 16 D0
	    ; SPRITE COLORS 
LB5DD:      lda (SPRCOLPTR),Y         ; B1 02
            sta COLPM3             ; 8D 15 D0
            inx                    ; E8
LB5E3:      beq LB60B              ; F0 26
            dey                    ; 88
            bpl LB5CB              ; 10 E3
            ldy TRAMSZ             ; A4 06
            lda M2PL               ; AD 0A D0
            and #$08               ; 29 08
            beq LB5F3              ; F0 02
            sty ABUFPT             ; 84 1C
LB5F3:      sta WSYNC              ; 8D 0A D4
            bit CMCMD              ; 24 07
            bpl LB602              ; 10 08
            lda DOSVEC+1           ; A5 0B
            sta COLPF0             ; 8D 16 D0
            jmp LB60A              ; 4C 0A B6
LB602:      lda P3PL               ; AD 0F D0
            lsr                    ; 4A
            bcc LB60A              ; 90 02
            sty ABUFPT+3           ; 84 1F
LB60A:      inx                    ; E8
LB60B:      beq LB66B              ; F0 5E
            lda P2PL               ; AD 0E D0
            lsr                    ; 4A
            bcc LB615              ; 90 02
            sty ABUFPT+2           ; 84 1E
LB615:      and #$04               ; 29 04
            beq LB61B              ; F0 02
            sty ABUFPT+1           ; 84 1D
LB61B:      lda P3PF               ; AD 07 D0
            lsr                    ; 4A
            sta WSYNC              ; 8D 0A D4
            eor CRITIC,Y           ; 59 42 00
            and #$01               ; 29 01
            eor CRITIC,Y           ; 59 42 00
            sta CRITIC,Y           ; 99 42 00
            inx                    ; E8
            beq LB66B              ; F0 3B
            lda M0PL               ; AD 08 D0
            and #$04               ; 29 04
            beq LB639              ; F0 02
            sty ICDNOZ             ; 84 21
LB639:      lda M0PF               ; AD 00 D0
            and #$03               ; 29 03
            beq LB642              ; F0 02
            sty ICCOMZ             ; 84 22
LB642:      lda P1PF               ; AD 05 D0
            sta WSYNC              ; 8D 0A D4
            and #$02               ; 29 02
            beq LB64E              ; F0 02
            sty ICHIDZ             ; 84 20
LB64E:      lda P2PF               ; AD 06 D0
            lsr                    ; 4A
            bcc LB656              ; 90 02
            sty DSKUTL+1           ; 84 1B
LB656:      lda M2PF               ; AD 02 D0
            and #$03               ; 29 03
            beq LB65F              ; F0 02
            sty DSKUTL             ; 84 1A
LB65F:      sta HITCLR             ; 8D 1E D0
            iny                    ; C8
            inx                    ; E8
            beq LB669              ; F0 03
            jmp LB565              ; 4C 65 B5
LB669:      stx DOSVEC             ; 86 0A
LB66B:      sta WSYNC              ; 8D 0A D4
            stx HPOSP1             ; 8E 01 D0
            stx HPOSP0             ; 8E 00 D0
            stx HPOSM0             ; 8E 04 D0
            stx COLPF3             ; 8E 19 D0
            lda #$3E               ; A9 3E
            sta DMACTL             ; 8D 00 D4
            lda #$1E               ; A9 1E
            sta COLPM1             ; 8D 13 D0
            ldx #$1E               ; A2 1E
            stx COLPF0             ; 8E 16 D0
            lda #$8E               ; A9 8E
            sta COLPF1             ; 8D 17 D0
            ldy KEYDEF             ; A4 79
            beq LB697              ; F0 05
            ldy DELTAC             ; A4 77
            beq LB697              ; F0 01
            tax                    ; AA
LB697:      stx COLPF2             ; 8E 18 D0
            lda INGAME             ; A5 76
            beq LB6AD              ; F0 0F
            ora ICBLHZ             ; 05 29
            bmi LB6AD              ; 30 0B
            lda DSKFMS             ; A5 18
            and #$30               ; 29 30
            bne LB6AD              ; D0 05
            lda #$06               ; A9 06
            sta COLPF0,Y           ; 99 16 D0
LB6AD:      lda #$08               ; A9 08
            sta CHBASE             ; 8D 09 D4
            lda #$04               ; A9 04
            sta WSYNC              ; 8D 0A D4
            sta PRIOR              ; 8D 1B D0
            lda #$06               ; A9 06
            sta COLBK              ; 8D 1A D0
            ldy TRAMSZ             ; A4 06
            cpy #$0B               ; C0 0B
            bcs LB727              ; B0 62
            lda #$0A               ; A9 0A
            ldx DOSVEC             ; A6 0A
            sta DOSVEC             ; 85 0A
            beq LB727              ; F0 5A
            lda P3PF               ; AD 07 D0
            lsr                    ; 4A
            eor CRITIC,Y           ; 59 42 00
            and #$01               ; 29 01
            eor CRITIC,Y           ; 59 42 00
            sta CRITIC,Y           ; 99 42 00
            lda M0PL               ; AD 08 D0
            and #$04               ; 29 04
            beq LB6E5              ; F0 02
            sty ICDNOZ             ; 84 21
LB6E5:      lda M0PF               ; AD 00 D0
            and #$03               ; 29 03
            beq LB6EE              ; F0 02
            sty ICCOMZ             ; 84 22
LB6EE:      lda M2PF               ; AD 02 D0
            and #$03               ; 29 03
            beq LB6F7              ; F0 02
            sty DSKUTL             ; 84 1A
LB6F7:      lda P2PF               ; AD 06 D0
            lsr                    ; 4A
            bcc LB6FF              ; 90 02
            sty DSKUTL+1           ; 84 1B
LB6FF:      lda P2PL               ; AD 0E D0
            lsr                    ; 4A
            bcc LB707              ; 90 02
            sty ABUFPT+2           ; 84 1E
LB707:      and #$04               ; 29 04
            beq LB70D              ; F0 02
            sty ABUFPT+1           ; 84 1D
LB70D:      lda P3PL               ; AD 0F D0
            lsr                    ; 4A
            bcc LB715              ; 90 02
            sty ABUFPT+3           ; 84 1F
LB715:      lda P1PF               ; AD 05 D0
            and #$02               ; 29 02
            beq LB71E              ; F0 02
            sty ICHIDZ             ; 84 20
LB71E:      lda M2PL               ; AD 0A D0
            and #$08               ; 29 08
            beq LB727              ; F0 02
            sty ABUFPT             ; 84 1C
LB727:      jmp XITVBV             ; 4C 62 E4
LB72A:      ldx #$00               ; A2 00
            lda #$3F               ; A9 3F
            sta DMACTL             ; 8D 00 D4
            sta WSYNC              ; 8D 0A D4
            lda #$0C               ; A9 0C
            sta COLPF0             ; 8D 16 D0
            stx COLBK              ; 8E 1A D0
            lda #$06               ; A9 06
            sta CHBASE             ; 8D 09 D4
            lda L00BF              ; A5 BF
            bne LB74B              ; D0 06
            sta WSYNC              ; 8D 0A D4
            sta WSYNC              ; 8D 0A D4
LB74B:      ldx #$03               ; A2 03
            stx SIZEP3             ; 8E 0B D0
            lda ICPTHZ             ; A5 27
            sta HPOSP3             ; 8D 03 D0
            adc #$15               ; 69 15
            tay                    ; A8
            ldx #$06               ; A2 06
LB75A:      sta WSYNC              ; 8D 0A D4
            sty HPOSP2             ; 8C 02 D0
            lda LB48D,X            ; BD 8D B4
            sta COLPM3             ; 8D 15 D0
            sta COLPM2             ; 8D 14 D0
            dey                    ; 88
            dex                    ; CA
            bpl LB75A              ; 10 ED
            sta WSYNC              ; 8D 0A D4
            sta HITCLR             ; 8D 1E D0
            jmp XITVBV             ; 4C 62 E4
DISPLLISTH:      .by $70,$F0,$30,$4E
DISPLLISTP:      .by $10,$46,$0,$10,$00,$06,$06,$A0
            .by $00,$56,<CREDITS,>CREDITS,$41,$00,$3F,$50
            .by $46,$0,$10,$30,$06,$06,$D0,$20
            .by $56,<CREDITS,>CREDITS,$41,$00,$3F
	    ; FUEL BEER COL MAP
	    ; B798
SPRCOLDATA: .by $16, $18,$18,$18,$1a,$18,$1a,$1a
            .by $1a,$1a, $1c, $1a,$1c,$1c,$1c,$1c
            .by $1e,$1c, $1e, $1e, $c, $e, $c,$e
	    ; B7B0 HELI
            .by $00,$00,$00,$80,$80,$28,$2A,$2A,$2A,$2A
	    ; B7BA HELI SHOOT
	    .by $00,$00,$00,$18,$0,$18,$2A,$2A,$2A,$2A
	    ; B7C0 PLANE
	    .by $A0,$A0,$90,$90,$80,$80
	    ; SHIP CMAP
	    ; B7CA
	    .by $A2,$10,$10,$12,$12,$12
	    ; B7D0 - BRIDGE LEGS OVERLAP WITH SHIP
	    .by $10,$10
	    ;
	    ; BRIDGE
	    .by $22,$14,$14,$12,$12,$14
            .by $14,$18,$18,$12,$12,$14,$14,$12
	    ; BALOON 
	    ; B7E0
        .by $b8,$ba,$ba,$cc,$dC,$EC,$A4,$A6
        .by $A6,$A6,$A8,$cA,$dA,$ec,$fC,$a4
        .by $a6,$a6,$a6,$a8
LB7F4:  
        .wo $8001,$8000,$0001,$0002
        .wo $0004,$FFFF,$FFAA,$55AA
        .wo $BF6A,$95EA,$AF5A,$A5FA
        .wo $AB56,$A9FE,$FFAA,$AAAA
        .wo $BFAA,$AAEA,$AFAA,$AAFA
        .wo $ABAA,$AAFE,$0000,$0000
        .wo $0000,$0000,$0000,$0000
        .wo $0000,$0000,$0000,$0000
        .wo $0000,$0000,$3F3F,$3F3F
        .wo $073F,$2D21,$0025,$362F
        .wo $3225,$3F3F,$3F3F
        .by $3F
CREDITS:
	.sb "        "
	.sb "        "
	.sb "        "
	.sb "  "
	.by "RIVER"-$40
	.sb " "
	.by "RAIDYZ"-$40
	.sb " "
	.by "by"-$40
	.sb " "
	.by "Carol"-$40
	.sb " "
	.by "Shaw"-$40
	.sb "    "
	.by "Copyright"-$40
	.sb " "
	.by "{|}zX{|}~"-$40
	.sb "   "
	.by "[\]^_"-$40
	.sb "     "
	.by "Grzybsoniada"-$40
	.sb " "
	.by "zk{{"-$40
	.sb " "
	.by "Edition"-$40
	.sb " "
	.by "by"-$40
	.sb " "
	.by "Jakub"-$40
	.sb " "
	.by "Husak"-$40
	;.sb "    "



        ;.by $00,$00,$12,$09,$16,$05,$12,$00
        ;.by $12,$01,$09,$04,$19,$1A,$00,$22
        ;.by $39,$00,$03,$21,$32,$2F,$2C,$00
        ;.by $13,$28,$21,$37,$00,$00,$00,$00
        ;.by $03,$2F,$30,$39,$32,$29,$27,$28
        ;.by $34,$00,$3B,$3C,$3D,$3A,$18,$3B
        ;.by $3C,$3D,$3E,$00,$00,$00,$1B,$1C
        ;.by $1D,$1E,$1F,$00,$00,$00,$00,$00
        ;.by $00,$00,$00,$00,$00,$00,$00,$00
        ;.by $00,$00,$00,$00,$00,$00,$00,$00
        ;.by $00,$00,$00,$10,$32,$25,$33,$33
        ;.by $00,$13,$14,$01,$12,$14,$00,$2B
        ;.by $25,$39,$00,$00,$00,$00,$15,$33
        .by $00,$00,$00,$00,$00,$00,$00,$00
        .by $00,$00,$00,$00,$00,$00,$00,$00
        .by $00,$00,$00,$00,$00,$00,$00,$00
        .by $00,$00,$00,$00,$00,$00,$00,$00
        .by $00,$00,$00,$1B,$1C,$1D,$1E,$1F
        .by $00,$00,$00,$00,$00,$00,$00,$00
        .by $00,$00,$00,$00,$FF
	    ; B900
SPRITEDATA:
	; EXPLOSIONS
        .by $00,$00,$00,$00,$00,$00,$00,$00
        .by $00,$00,$00,$00,$00,$00,$00,$00
        .by $00,$00,$00,$00,$00,$00,$00,$00
        .by $00,$00,$00,$00,$14,$48,$54,$2A
        .by $89,$2A,$A4,$1A,$61,$8C,$23,$C4
        .by $19,$29,$92,$8A,$45,$94,$8A,$2A
        .by $91,$4A,$24,$12,$02,$14,$22,$11
        .by $44,$82,$48,$81,$14,$42,$88,$22
        .by $48,$14,$41,$24,$88,$22,$14,$41
        .by $22,$84,$10,$08,$00,$00,$00,$04
        .by $12,$48,$12,$44,$08,$10,$44,$10
        .by $24,$02,$24,$40,$12,$48,$20,$04
        .by $40,$00,$00,$00
	; B964
LB964:      .by $10
	; FUEL BEER
	; B965
	    .by %00111110
	    .by %00101010
	    .by %00100110
	    .by %00101010
	    .by %00100110
	    .by %00111110
	    .by %01100010
	    .by %11101110
	    .by %10100010
	    .by %10101110
	    .by %10100010
	    .by %10111110
	    .by %10100010
	    .by %11101110
	    .by %01100010
	    .by %00101110
	    .by %00100010
	    .by %00111110
	    .by %00100110
	    .by %00101010
	    .by %01100111
	    .by %01101011
	    .by %01100111
	    .by %00111110
	    ; SHIP UPSIDE DOWN RIGHT
	    ; B97D
            .by %11111111
            .by %11111110
            .by %11111101
            .by %01101100
            .by %00110010
            .by %00011101
            .by %00011000
            .by %00000110
	    ; PLANE RIGHT UPSIDE DOWN
	    ; B985
        .by %00110000
        .by %00111000
        .by %01001111
        .by %11111111
        .by %11000110
        .by %10000000
	    ; HELI RIGHT 1 UPSIDE DOWN
	    ; B98B
        .by %01010100
        .by %01110100
        .by %11111011
        .by %11111111
        .by %01111011
        .by %00011000
        .by %01111000
        .by %11110000
        .by %11110000
        .by %01100000
	    ; HELI RIGHT 2 UPSIDE DOWN
	    ; B995
        .by %01010100
        .by %01110100
        .by %11111011
        .by %11111111
        .by %01111011
        .by %01111000
        .by %11110000
        .by %01100000
        .by %00000000
        .by %00000000
	    ; SHIP UPSIDE DOWN LEFT
	    ; B99F
            .by %11111111
            .by %11111111
            .by %11111100
            .by %01101101
            .by %00110010
            .by %00011011
            .by %00011100
            .by %00000011
	    ; PLANE LEFT UPSIDE DOWN
	    ; B9A7
        .by %00001100
        .by %00011100
        .by %11110010
        .by %11111111
        .by %01100011
        .by %00000001
	    ; HELI LEFT UPSIDE DOWN 1
	    ; B9AD
        .by %00101010
        .by %00101110
        .by %11011111
        .by %11111111
        .by %11011110
        .by %00011000
        .by %00011110
        .by %00001111
        .by %00001111
        .by %00000110
	    ; HELI LEFT UPSIDE DOWN 2
	    ; B9B7
        .by %00101010
        .by %00101110
        .by %11011111
        .by %11111111
        .by %11011110
        .by %00011110
        .by %00001111
        .by %00000110
        .by %00000000
        .by %00000000
	    ; BRIDGE UPSIDE DOWN
	    ; B9C1
        .by %00000000
        .by %00100100
        .by %00100100
        .by %11111111
        .by %11111111
        .by %11111111
        .by %11111111
        .by %11111111
        .by %11111111
        .by %11111111
        .by %11111111
        .by %11111111
        .by %11111111
        .by %11111111
        .by %11111111
        .by %11111111
        .by %00000000
        .by %11111111
	; BALOON UPSIDE DOWN
	; B9D3

        .by %00000000
        .by %00000000
        .by %00001000
        .by %00001000
        .by %00110100
        .by %00010011
        .by %00111000
        .by %00101000
        .by %01100000
        .by %11010110
        .by %11110011
        .by %01101111
        .by %00000110
        .by %00100000
        .by %01110010
        .by %01010111
        .by %00000101
        .by %01100100
        .by %11100100
        .by %11011010
        .by %11111010
        .by %01110001

	    ; TANK R R L L
	    ; B9E9
	    .by %00000000
	    .by %00000000
	    .by %00000000
	    .by %00111000
	    .by %01111000
	    .by %00111100
	    .by %01111010
	    .by %10110000
	    .by %01011000
	    .by %00100100
	    .by %11101110
	    ;
	    .by %00000000
	    .by %00000000
	    .by %00110000
	    .by %01111000
	    .by %00111000
	    .by %00111000
	    .by %00110000
	    .by %00110000
	    .by %00110000
	    .by %00011000
	    .by %00111000
	    ;
	    .by %00000000
	    .by %00000000
	    .by %00000000
	    .by %00011100
	    .by %00011110
	    .by %00111100
	    .by %01011110
	    .by %00001101
	    .by %00011010
	    .by %00100100
	    .by %01110111
	    ;
	    .by %00000000
	    .by %00000000
	    .by %00001100
	    .by %00011110
	    .by %00011100
	    .by %00011100
	    .by %00001100
	    .by %00001100
	    .by %00001100
	    .by %00011000
	    .by %00011100
	    ; TANK MISSILE EXPLOSION
	    ; BA15
	    .by $00,$00,$00,$00,$00,$00,$00,$00, $00,$18
	    ; BA1F
	    .by $00,$00,$00,$00,$00,$00,$00,$00, $18,$18,$18,$18
	    ; BA2B
	    .by $00,$00,$00,$00,$00,$00,$00,$18, $3C,$3C,$3C,$3C,$18
	    ; BA38
	    .by $00,$00,$00,$00,$00,$00,$18,$3C, $3C,$3C,$3C,$3C,$3C,$18
	    ; BA46
	    .by $00,$00,$00,$00,$00,$18,$3C,$3C, $7E,$7E,$7E,$7E,$3C,$3C,$18
	    ; BA55
	    .by $00,$00,$00,$00,$3C,$7E,$7E,$FF, $FF,$FF,$FF,$FF,$FF,$7E,$7E,$3C
	    ; BA65 CRAFT
	    .by $08,$08,$08,$1C,$3E,$7F,$7F,$6B, $49,$08,$1C,$3E,$2A,$00
	    ; BA73 CRAFT RIGHT
	    .by $08,$08,$08,$18,$3C,$3E,$3E,$2E, $0A,$08,$18,$3C,$2E,$02
	    ; BA81 CRAFT LEFT
	    .by $08,$08,$08,$0C,$1E,$3E,$3E,$3A, $28,$08,$0C,$1E,$3A,$20
	    ;
LBA8F:      .by $00,$01,$FF,$FF,$00,$01,$00,$00
            .by $01,$00,$01,$FF,$00,$FF,$FF,$FF
            .by $00,$01,$01,$00,$01,$FF,$FF,$00
            .by $00,$FF,$00,$00,$00,$01,$01,$00
LBAAF:      .by $00,$00,$01,$02,$05,$04,$07,$06
	; TANK MISSLE EXPLOSION VECTORS
LBAB7:      .wo $B900,$BA15,$BA1F,$BA2B
            .wo $BA38,$BA46,$BA55
	    ; TANK MISSILE COLORS
LBAC5:      .by $16,$16,$14,$14,$14,$12,$12,$12
		; CRAFT ADDRESSES
LBACD:      
	    .wo $B900,$B900,$B94C,$B934
            .wo $B91C,$B934,$B94C
KAYAKLEFT:
	    .wo KL1
KAYAKRIGHT:
            .wo KR1
KAYAKSTRAIGHT: 
	    .wo KS0
LBAE1:
        .wo $0B0B,$FF02,$200B,$3614
        .wo $0100,$007C,$01FE,$FFFF
        .wo $0011,$010D,$0000,$0000
        .wo $0000,$0000,$0400,$0001
        .wo $0000,$0000,$0000,$0000
        .wo $8004

LBB0B:      .by $00,$00,$00,$00,$00,$00,$00,$10
            .by $06,$06,$15,$15,$06,$03,$50,$08
            .by $75
LBB1C:      .by $0D,$08,$0D,$08,$07,$0D,$08,$0C
LBB24:      .by $00,$01,$03,$04,$05,$06,$00,$07
            .by $09,$08,$0B,$0A
	    ; LO BYTE SPRITE COLOR POINTERS (HI BYTE B7)
LBB30:      .by $00,$00,$00,$00,$00,$00,$00,$C4
            .by $B0,$B0,$BA,$BA,$E0,$CA,$CF,$98
	    ; LO BYTE SPRITE ADDR POINTERS (HI BYTE B9) RIGHT
LBB40:      .by $00,$00,$4C,$34,$1C,$34,$4C,$85
            .by $8B,$95,$8B,$95,$D5,$7D,$C1,$65
	    ; LEFT
            .by $00,$00,$4C,$34,$1C,$34,$4C,$A7
            .by $AD,$B7,$AD,$B7,$D5,$9F,$C1,$65
	    ; SPRITE HEIGHTS
LBB60:      .by $17,$05,$05,$05,$05,$05,$05,$05
            .by $09,$09,$09,$09,$13,$07,$13,$17
LBB70:      .by $00,$1A,$00,$00,$00,$00,$00,$00
            .by $10,$00,$00,$5B,$00,$00,$00,$00
            .by $00,$00,$50,$00,$00,$E7,$E1,$ED
            .by $E5,$C7,$C8,$C9,$C8,$CA,$00
LBB8F:      .by $83,$84,$85,$86,$00,$00,$00,$91
            .by $00,$00,$00,$00,$D1,$00,$CB,$CC
            .by $CD,$CC,$CE
LBBA2:      .by $00,$00,$00,$00,$00,$00,$00,$00
            .by $00,$00,$00,$00,$00,$01,$03,$00
MOUNTAINWIDTHS:
	    .by $05,$08,$03,$04,$05,$06,$06,$08
            .by $08,$0A,$08,$08,$0A,$0A,$0A,$0A
            .by $03,$05,$06,$08,$08,$08,$0A,$0A
            .by $0A,$0A
LBBCC:      .by $07,$04,$08,$06,$06,$04,$05,$04
LBBD4:      .by $04,$04,$04,$04,$04,$04,$05,$04
            .by $05,$04,$07,$08,$06,$08,$09,$0A
            .by $17,$16,$15,$14,$13,$15,$13
LBBEB:      .by $12,$14,$15,$0C,$0C
		; MOUNTAINS
LBBF0:      .by $14,$0E,$0E,$16,$16,$1E
LBBF6	    .wo MOUNT1
            .wo MOUNT2,MOUNT3,MOUNT4,MOUNT4
            .wo MOUNT5,MOUNT5,MOUNT6
	    ; BC06
MOUNT1
            .HE  65 94 54 55
            .HE  54 54 69 44 44 69 44 44
            .HE  aa 44 44 aa 44 00 44 43
            .HE  c8 44 40 28 45 15 28 14
            .HE  41 28 00 51 21 55 01 05
	    ; BC2A
MOUNT2
            .HE  00 01 54 01 00 02 54 00
            .HE  80 02 56 00 6a aa 95 00
            .HE  6a 0a 95 45 5a aa 95 45
            .HE  54 00 55 45 54 fc 15 45
            .HE  54 fc 15 55 54 7c 15 55
            .HE  54 00 15 55 55 00 15 55
	    ; BC5A
MOUNT3
        .by $AA,$BA,$AE,$AA,$AA,$6A,$BA,$AE
        .by $AA,$A9,$5A,$BE,$AF,$AA,$A9,$5A
        .by $BF,$AB,$AA,$A9,$5A,$AF,$AB,$EA
        .by $A5,$5A,$AF,$AB,$EA,$A5,$56,$AB
        .by $AA,$EA,$A5,$56,$AB,$AA,$FA,$A5
        .by $56,$A9,$AA,$BA,$A5,$56,$A9,$AA
        .by $BE,$A5,$56,$A5,$6A,$A6,$95,$56
        .by $A5,$6A,$A6,$95,$55,$95,$5A,$96
        .by $95,$55,$95,$5A,$95,$95,$55,$55
        .by $5A,$95,$95,$55,$55,$5A,$95,$95
        .by $55,$55,$56,$55,$55,$55,$55,$56
        .by $55,$55,$55,$55,$56,$55,$55,$55
        .by $55,$56,$55,$55
	    ; BCBE
MOUNT4	
        .by $AA,$AA,$AA,$AA,$AA,$00,$6A,$AA
        .by $AA,$A2,$AA,$01,$5A,$AA,$AA,$82
        .by $A8,$01,$5A,$A8,$AA,$0A,$A8,$05
        .by $56,$A8,$28,$0A,$A8,$05,$56,$AA
        .by $08,$2A,$A0,$15,$56,$AA,$80,$6A
        .by $00,$55,$55,$AA,$81,$6A,$01,$55
        .by $55,$AA,$01,$58,$05,$55,$55,$6A
        .by $05,$58,$15,$55,$55,$58,$15,$54
        .by $55,$55,$55,$58,$15,$54,$55,$55
        .by $55,$54,$55,$55,$55,$55,$55,$54
LBD0E:      .by $55,$55,$55,$55
	    ; BD12
MOUNT5 
        .by $55,$55,$55,$95,$55,$55,$55,$55
        .by $6A,$55,$6A,$A9,$55,$55,$55,$55
        .by $AA,$AA,$AA,$AA,$AF,$EA,$AB,$55
        .by $AA,$AA,$AA,$AA,$AF,$AA,$AB,$D5
        .by $6A,$AA,$AA,$AA,$AF,$AA,$AB,$F5
        .by $6A,$AA,$AA,$AA,$BF,$AA,$AB,$FF
        .by $5A,$AA,$FA,$AA,$BE,$AA,$AF,$FF
        .by $5A,$AA,$FA,$AA,$BE,$AA,$AF,$FF
        .by $5A,$AB,$EA,$AA,$FA,$AA,$AF,$FF
        .by $56,$AF,$EA,$AA,$FA,$AA,$AF,$FD
        .by $55,$AF,$AA,$AA,$EA,$AA,$AF,$FD
        .by $55,$BD,$AA,$AB,$EA,$AA,$AF,$F5
        .by $55,$75,$AA,$AB,$AA,$AA,$BF,$F5
        .by $55,$75,$6A,$AB,$AA,$AA,$BF,$F5
        .by $55,$55,$6A,$A9,$AA,$AA,$BF,$D5
        .by $55,$55,$5A,$A5,$6A,$AA,$BF,$55
        .by $55,$55,$5A,$95,$5A,$AA,$BF,$55
        .by $55,$55,$56,$55,$55,$AA,$BD,$55
        .by $55,$55,$56,$55,$55,$5A,$BD,$55
        .by $55,$55,$55,$55,$55,$56,$B5,$55
        .by $55,$55,$55,$55,$55,$55,$B5,$55
        .by $55,$55,$55,$55,$55,$55,$75,$55
	    ; BDC2
MOUNT6:      
            .HE  55 55 55 55
            .HE  55 55 55 55 55 55 55 55
            .HE  55 55 55 55 55 55 55 55
            .HE  54 00 00 15 55 55 55 40
            .HE  00 05 55 04 11 55 55 55
            .HE  55 41 04 55 55 14 11 55
            .HE  55 55 55 41 05 55 55 54
            .HE  15 55 55 55 55 11 01 55
            .HE  55 50 15 55 55 55 55 55
            .HE  41 55 55 50 55 55 55 55
            .HE  55 55 41 55 50 40 55 55
            .HE  55 55 55 55 41 55 50 01
            .HE  55 55 55 55 55 55 50 55
            .HE  41 00 55 55 55 55 55 55
            .HE  50 01 41 54 01 55 55 55
            .HE  55 55 01 51 41 55 40 15
            .HE  55 55 55 00 55 50 46 95
            .HE  55 00 15 55 40 55 57 70
            .HE  49 b7 55 54 00 00 05 55
            .HE  a7 f4 49 b7 a9 55 55 55
            .HE  55 77 9b 74 49 7f 95 d9
            .HE  55 55 76 7f 9b 74 49 77
            .HE  65 da 7d 67 f6 77 9b 74
            .HE  46 b7 65 d9 97 ab f6 77
            .HE  9b f4 41 7d 59 d9 9d 9b
            .HE  f6 77 a5 40 50 55 ab 7a
            .HE  75 9b f6 7f 54 05 55 05
            .HE  57 79 b5 9b 76 55 40 55
            .HE  55 40 15 56 5f 67 55 50
            .HE  05 55 55 55 41 55 55 55
            .HE  55 01 55 55 55 55 54 01
            .HE  55 55 00 55 55 55 55 55
            .HE  55 50 00 00 15 55 55 55
            .HE  55 55 55 55 55 55 55 55
            .HE  55 55 55 55 55 55 55 55
            .HE  55 55 55 55 55 55 55 55
            .HE  55 55 55 55 55 55 55 55
            .HE  55 55 55 55 55 55 55 55
;        .by $55,$55,$55,$55,$55,$69,$55,$55
;        .by $55,$55,$55,$5a,$aa,$55,$5a,$aa
;        .by $95,$55,$55,$55,$aa,$aa,$aa,$aa
;        .by $aa,$aa,$aa,$aa,$55,$55,$5a,$aa
;        .by $aa,$aa,$aa,$aa,$aa,$a9,$55,$55
;        .by $56,$aa,$aa,$aa,$aa,$aa,$aa,$a5
;        .by $55,$55,$56,$aa,$aa,$aa,$aa,$aa
;        .by $aa,$a5,$55,$55,$55,$aa,$aa,$aa
;        .by $aa,$aa,$aa,$15,$55,$55,$55,$6a
;        .by $aa,$aa,$aa,$aa,$aa,$15,$55,$55
;        .by $55,$6a,$aa,$aa,$aa,$aa,$a8,$15
;        .by $55,$55,$55,$5a,$aa,$aa,$aa,$aa
;        .by $a8,$55,$55,$55,$55,$5a,$aa,$aa
;        .by $aa,$aa,$a8,$55,$55,$55,$55,$55
;        .by $aa,$aa,$aa,$aa,$a0,$55,$55,$55
;        .by $55,$55,$6a,$aa,$aa,$aa,$a2,$aa
;        .by $a0,$01,$55,$55,$6a,$aa,$aa,$aa
;        .by $82,$aa,$a0,$05,$55,$55,$5a,$aa
;        .by $a8,$2a,$8a,$aa,$a0,$15,$55,$55
;        .by $56,$aa,$aa,$2a,$8a,$aa,$80,$15
;        .by $55,$55,$56,$aa,$aa,$0a,$0a,$aa
;        .by $80,$55,$55,$55,$56,$aa,$aa,$8a
;        .by $2a,$aa,$81,$55,$55,$55,$55,$aa
;        .by $aa,$80,$2a,$aa,$01,$55,$55,$55
;        .by $55,$7e,$aa,$80,$aa,$aa,$05,$55
;        .by $55,$55,$55,$5f,$aa,$80,$aa,$aa
;        .by $05,$55,$55,$55,$55,$57,$aa,$80
;        .by $6a,$a8,$15,$55,$55,$55,$55,$57
;        .by $ea,$81,$5a,$a8,$15,$55,$55,$55
;        .by $55,$55,$ea,$81,$56,$a8,$55,$55
;        .by $55,$55,$55,$55,$fa,$81,$55,$a0
;        .by $55,$55,$55,$55,$55,$55,$7a,$85
;        .by $55,$61,$55,$55,$55,$55,$55,$55
;        .by $7e,$85,$55,$59,$55,$55,$55,$55
;        .by $55,$55,$5e,$15,$55,$55,$55,$55
;        .by $55,$55,$55,$55,$5f,$15,$55,$55
;        .by $55,$55,$55,$55,$55,$55,$57,$15
;        .by $55,$55,$55,$55
ACTIVISIONTFONT:  
        .by %00000000
        .by %00000000
        .by %00000000
        .by %00000000
        .by %00000000
        .by %01100000
        .by %01100000
        .by %11000000
        .by %01110100
        .by %00100110
        .by %00100111
        .by %00100101
        .by %00100100
        .by %00000000
        .by %00000000
        .by %00000000
        .by %01000000
        .by %11000000
        .by %11000000
        .by %01000000
        .by %01000000
        .by %00000000
        .by %00000000
        .by %00000000
        .by %00000000
        .by %00000000
        .by %00000000
        .by %00000001
        .by %00000011
        .by %00000110
        .by %00001100
        .by %00000000
        .by %00101111
        .by %01100001
        .by %11101101
        .by %10101001
        .by %11101001
        .by %00101001
        .by %00101101
        .by %00000000
        .by %11110000
        .by %00010001
        .by %01010011
        .by %01010110
        .by %01011100
        .by %01011000
        .by %01010000
        .by %00000000
        .by %11111110
        .by %10000000
        .by %00111010
        .by %10100010
        .by %10111010
        .by %10001010
        .by %10111010
        .by %00000000
        .by %00000000
        .by %00000000
        .by %11101001
        .by %10101101
        .by %10101111
        .by %10101011
        .by %11101001
        .by %00000000
STATUSFONT:  
        .by %00000000
        .by %11100111
        .by %10110101
        .by %11100101
        .by %10110111
        .by %10110101
        .by %11100100
        .by %00000000
        .by %00000000
        .by %00111011
        .by %10010010
        .by %10010010
        .by %00010010
        .by %10010010
        .by %10111011
        .by %00000000
        .by %00000000
        .by %10001110
        .by %11011000
        .by %01010000
        .by %01010110
        .by %11011010
        .by %10001110
        .by %00000000
        .by %00000000
        .by %11100000
        .by %10000000
        .by %11000000
        .by %10000000
        .by %10000000
        .by %11100000
        .by %00000000
        .by %01111111
        .by %01001100
        .by %01001100
        .by %01001100
        .by %01001100
        .by %01000000
        .by %01000000
        .by %01001111
        .by %11111111
        .by %00000000
        .by %00000000
        .by %00000000
        .by %00000000
        .by %00000000
        .by %00000000
        .by %00000000
        .by %11111111
        .by %00001000
        .by %00001000
        .by %01001000
        .by %11000000
        .by %01000011
        .by %01000110
        .by %11101100
        .by %11111111
        .by %00011001
        .by %00011001
        .by %00011001
        .by %00011001
        .by %00000001
        .by %00000001
        .by %11110001
        .by %01001000
        .by %01001000
        .by %01001110
        .by %01001000
        .by %01001000
        .by %01001111
        .by %01000000
        .by %01111111
        .by %00000000
        .by %00000000
        .by %00000000
        .by %00000000
        .by %00000000
        .by %00000000
        .by %00000000
        .by %11111111
        .by %00011000
        .by %00110111
        .by %01100001
        .by %11000111
        .by %00000100
        .by %00000111
        .by %00000000
        .by %11111111
        .by %10000001
        .by %10000001
        .by %11100001
        .by %10000001
        .by %10000001
        .by %10000001
        .by %00000001
        .by %11111111
        .by %00000000
        .by %00000000
        .by %11101110
        .by %10100010
        .by %11101110
        .by %10001000
        .by %10001110
        .by %00000000
        .by %00000000
        .by %00111100
        .by %01100110
        .by %01100110
        .by %01100110
        .by %01100110
        .by %00111100
        .by %00000000
LBF9E:
        .by %00000000
        .by %00000000
        .by %11100100
        .by %10101100
        .by %11100100
        .by %10000100
        .by %10001110
        .by %00000000
        .by %00000000
        .by %00000000
        .by %10101110
        .by %10100100
        .by %11100100
        .by %10100100
        .by %10101110
        .by %00000000
        .by %00000001
        .by %00000111
        .by %00011110
        .by %00100110
        .by %01100100
        .by %01111000
        .by %11100000
        .by %10000000
LBFB6: 
        .by %00000000
        .by %00111100
        .by %01100110
        .by %00001100
        .by %00011000
        .by %00110000
        .by %01111110
        .by %00000000
        .by %00000000
        .by %00011000
        .by %00111000
        .by %00011000
        .by %00011000
        .by %00011000
        .by %01111110
        .by %00000000
        .by %00000000
        .by %00111100
        .by %01100110
        .by %00111110
        .by %00000110
        .by %00001100
        .by %00111000
        .by %00000000
        .by %00000000
        .by %00111100
        .by %01100110
        .by %00111100
        .by %01100110
        .by %01100110
        .by %00111100
        .by %00000000
        .by %00000000
        .by %01111110
        .by %00001100
        .by %00011000
        .by %00001100
        .by %01100110
        .by %00111100
        .by %00000000
        .by %00000000
        .by %00000000
        .by %00000000
        .by %00000000
        .by %00000000
        .by %00011000
LBFE4:  
        .by %00011000
        .by %00000000
        .by %10010110
        .by %00000100
        .by %10001100
        .by %00010000
        .by %10001110
        .by %00001100
        .by %01111100
        .by %00100000
        .by %10000110
        .by %00010100
        .by %01101100
        .by %00110000
        .by %11111111
        .by %11111111
        .by %11111111
        .by %11111111
        .by %11111111
        .by %11111111
        .by %11111111
        .by %11111111
        .by %00000000
        .by %10100000
        .by %00000000
        .by %10000000
        .by %00000000
        .by %10100000
;
;            org $02E0
;
;            .wo LA000
;
        run INTROSTART 
